/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf;

import edu.internet2.middleware.shibboleth.common.ShibbolethConfigurationException;
import edu.internet2.middleware.shibboleth.wayf.DiscoveryResponseImpl;
import edu.internet2.middleware.shibboleth.wayf.HandlerConfig;
import edu.internet2.middleware.shibboleth.wayf.IdPSite;
import edu.internet2.middleware.shibboleth.wayf.IdPSiteSet;
import edu.internet2.middleware.shibboleth.wayf.IdPSiteSetEntry;
import edu.internet2.middleware.shibboleth.wayf.WayfException;
import edu.internet2.middleware.shibboleth.wayf.plugins.Plugin;
import edu.internet2.middleware.shibboleth.wayf.plugins.PluginContext;
import edu.internet2.middleware.shibboleth.wayf.plugins.PluginMetadataParameter;
import edu.internet2.middleware.shibboleth.wayf.plugins.WayfRequestHandled;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscoveryServiceHandler {
    private static final String SHIRE_PARAM_NAME = "shire";
    private static final String TARGET_PARAM_NAME = "target";
    private static final String TIME_PARAM_NAME = "time";
    private static final String PROVIDERID_PARAM_NAME = "providerId";
    private static final String ENTITYID_PARAM_NAME = "entityID";
    private static final String RETURN_PARAM_NAME = "return";
    private static final String RETURN_ATTRIBUTE_NAME = "returnX";
    private static final String RETURN_INDEX_NAME = "returnIndex";
    private static final String RETURNID_PARAM_NAME = "returnIDParam";
    private static final String RETURNID_DEFAULT_VALUE = "entityID";
    private static final String ISPASSIVE_PARAM_NAME = "isPassive";
    private static final String POLICY_PARAM_NAME = "policy";
    private static final String KNOWN_POLICY_NAME = "urn:oasis:names:tc:SAML:profiles:SSO:idp-discoveryprotocol:single";
    private static final Logger LOG = LoggerFactory.getLogger((String)DiscoveryServiceHandler.class.getName());
    private final String location;
    private final boolean isDefault;
    private final HandlerConfig config;
    private final List<IdPSiteSet> siteSets;
    private final List<Plugin> plugins;

    protected DiscoveryServiceHandler(Element config, Hashtable<String, IdPSiteSet> federations, Hashtable<String, Plugin> plugins, HandlerConfig defaultConfig) throws ShibbolethConfigurationException {
        int i;
        this.siteSets = new ArrayList<IdPSiteSet>(federations.size());
        this.plugins = new ArrayList<Plugin>(plugins.size());
        this.config = new HandlerConfig(config, defaultConfig);
        this.location = config.getAttribute("location");
        if (this.location == null || this.location.equals("")) {
            LOG.error("DiscoveryService must have a location specified");
            throw new ShibbolethConfigurationException("DiscoveryService must have a location specified");
        }
        String attribute = config.getAttribute("default");
        this.isDefault = attribute != null && !attribute.equals("") ? Boolean.valueOf(attribute) : true;
        NodeList list = config.getElementsByTagName("Federation");
        for (i = 0; i < list.getLength(); ++i) {
            attribute = ((Element)list.item(i)).getAttribute("identifier");
            IdPSiteSet siteset = federations.get(attribute);
            if (siteset == null) {
                LOG.error("Handler " + this.location + ": could not find metadata for <Federation> with identifier " + attribute + ".");
                throw new ShibbolethConfigurationException("Handler " + this.location + ": could not find metadata for  <Federation> identifier " + attribute + ".");
            }
            this.siteSets.add(siteset);
        }
        if (this.siteSets.size() == 0) {
            this.siteSets.addAll(federations.values());
        }
        list = config.getElementsByTagName("PluginInstance");
        for (i = 0; i < list.getLength(); ++i) {
            attribute = ((Element)list.item(i)).getAttribute("identifier");
            Plugin plugin = plugins.get(attribute);
            if (plugin == null) {
                LOG.error("Handler " + this.location + ": could not find plugin for identifier " + attribute);
                throw new ShibbolethConfigurationException("Handler " + this.location + ": could not find plugin for identifier " + attribute);
            }
            this.plugins.add(plugin);
        }
        for (IdPSiteSet site : this.siteSets) {
            for (Plugin plugin : this.plugins) {
                site.addPlugin(plugin);
            }
        }
    }

    protected String getLocation() {
        return this.location;
    }

    protected boolean isDefault() {
        return this.isDefault;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        String policy = req.getParameter(POLICY_PARAM_NAME);
        if (null != policy && !KNOWN_POLICY_NAME.equals(policy)) {
            LOG.error("Unknown policy " + policy);
            this.handleError(req, res, "Unknown policy " + policy);
            return;
        }
        String requestType = req.getParameter("action");
        if (requestType == null || requestType.equals("")) {
            requestType = "lookup";
        }
        try {
            if (requestType.equals("search")) {
                String parameter = req.getParameter("string");
                if (parameter != null && parameter.equals("")) {
                    parameter = null;
                }
                this.handleLookup(req, res, parameter);
            } else if (requestType.equals("selection")) {
                this.handleSelection(req, res);
            } else {
                this.handleLookup(req, res, null);
            }
        }
        catch (WayfException we) {
            LOG.error("Error processing DS request:", (Throwable)we);
            this.handleError(req, res, we.getLocalizedMessage());
        }
        catch (WayfRequestHandled we) {
            // empty catch block
        }
    }

    private void handleSelection(HttpServletRequest req, HttpServletResponse res) throws WayfRequestHandled, WayfException {
        String idpName = req.getParameter("origin");
        LOG.debug("Processing handle selection: " + idpName);
        String sPName = DiscoveryServiceHandler.getSPId(req);
        if (idpName == null || idpName.equals("")) {
            this.handleLookup(req, res, null);
            return;
        }
        if (DiscoveryServiceHandler.getValue(req, SHIRE_PARAM_NAME) == null) {
            this.setupReturnAddress(sPName, req);
        }
        IdPSite site = null;
        for (Plugin plugin : this.plugins) {
            for (IdPSiteSet idPSiteSet : this.siteSets) {
                PluginMetadataParameter param = idPSiteSet.paramFor(plugin);
                plugin.selected(req, res, param, idpName);
                if (site != null || !idPSiteSet.containsIdP(idpName)) continue;
                site = idPSiteSet.getSite(idpName);
            }
        }
        if (site == null) {
            this.handleLookup(req, res, null);
        } else {
            DiscoveryServiceHandler.forwardRequest(req, res, site);
        }
    }

    private void setupReturnAddress(String spName, HttpServletRequest req) throws WayfException {
        HashSet objects = new HashSet();
        String defaultName = null;
        for (IdPSiteSet metadataProvider : this.siteSets) {
            if (!metadataProvider.containsSP(spName)) continue;
            EntityDescriptor entity = metadataProvider.getEntity(spName);
            List roles = entity.getRoleDescriptors();
            for (RoleDescriptor role : roles) {
                Extensions exts;
                if (!(role instanceof SPSSODescriptor) || (exts = role.getExtensions()) == null) continue;
                objects.addAll(exts.getOrderedChildren());
            }
        }
        DiscoveryResponseImpl[] discoveryServices = new DiscoveryResponseImpl[objects.size()];
        int dsCount = 0;
        for (XMLObject obj : objects) {
            if (!(obj instanceof DiscoveryResponseImpl)) continue;
            DiscoveryResponseImpl ds = (DiscoveryResponseImpl)obj;
            discoveryServices[dsCount++] = ds;
            if (!ds.isDefault().booleanValue() && null != defaultName) continue;
            defaultName = ds.getLocation();
        }
        String returnName = req.getParameter(RETURN_PARAM_NAME);
        if (returnName == null || returnName.length() == 0) {
            returnName = DiscoveryServiceHandler.getValue(req, RETURN_ATTRIBUTE_NAME);
        }
        String returnIndex = req.getParameter(RETURN_INDEX_NAME);
        if (returnName != null && returnName.length() != 0) {
            URL providedReturnURL;
            String nameNoParam = returnName;
            int index = nameNoParam.indexOf(63);
            boolean found = false;
            if (index >= 0) {
                nameNoParam = nameNoParam.substring(0, index);
            }
            try {
                providedReturnURL = new URL(nameNoParam);
            }
            catch (MalformedURLException e) {
                throw new WayfException("Couldn't parse provided return name " + nameNoParam, e);
            }
            for (DiscoveryResponseImpl disc : discoveryServices) {
                if (!DiscoveryServiceHandler.equalsURL(disc, providedReturnURL)) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new WayfException("Couldn't find endpoint " + nameNoParam + " in metadata");
            }
        } else if (returnIndex != null && returnIndex.length() != 0) {
            int index;
            try {
                index = Integer.parseInt(returnIndex);
            }
            catch (NumberFormatException e) {
                throw new WayfException("Couldn't convert " + returnIndex + " into an index");
            }
            boolean found = false;
            for (DiscoveryResponseImpl disc : discoveryServices) {
                if (index != disc.getIndex()) continue;
                found = true;
                returnName = disc.getLocation();
                break;
            }
            if (!found) {
                throw new WayfException("Couldn't not find endpoint " + returnIndex + "in metadata");
            }
        } else {
            returnName = defaultName;
        }
        req.setAttribute(RETURN_ATTRIBUTE_NAME, (Object)returnName);
    }

    private static boolean equalsURL(DiscoveryResponseImpl discovery, URL providedName) {
        URL discoveryName;
        if (null == discovery) {
            return false;
        }
        try {
            discoveryName = new URL(discovery.getLocation());
        }
        catch (MalformedURLException e) {
            LOG.warn("Found invalid discovery end point : " + discovery.getLocation(), (Throwable)e);
            return false;
        }
        return providedName.equals(discoveryName);
    }

    private void handleLookup(HttpServletRequest req, HttpServletResponse res, String searchName) throws WayfException, WayfRequestHandled {
        String shire = DiscoveryServiceHandler.getValue(req, SHIRE_PARAM_NAME);
        String providerId = DiscoveryServiceHandler.getSPId(req);
        boolean twoZeroProtocol = shire == null;
        boolean isPassive = twoZeroProtocol && "true".equalsIgnoreCase(DiscoveryServiceHandler.getValue(req, ISPASSIVE_PARAM_NAME));
        ArrayList<IdPSiteSetEntry> siteLists = null;
        TreeSet<IdPSite> searchResults = null;
        if (this.config.getProvideListOfLists()) {
            siteLists = new ArrayList<IdPSiteSetEntry>(this.siteSets.size());
        }
        TreeSet<IdPSite> sites = null;
        IdPSite.Compare comparator = new IdPSite.Compare(req);
        if (this.config.getProvideList()) {
            sites = new TreeSet<IdPSite>(comparator);
        }
        if (searchName != null && !searchName.equals("")) {
            searchResults = new TreeSet<IdPSite>(comparator);
        }
        LOG.debug("Processing Idp Lookup for : " + providerId);
        PluginContext[] ctx = new PluginContext[this.plugins.size()];
        ArrayList<IdPSite> hintList = new ArrayList<IdPSite>();
        if (twoZeroProtocol) {
            this.setupReturnAddress(providerId, req);
        }
        try {
            for (IdPSiteSet metadataProvider : this.siteSets) {
                if (!metadataProvider.containsSP(providerId) && this.config.getLookupSp()) continue;
                TreeSet<IdPSite> search = null;
                if (searchResults != null) {
                    search = new TreeSet<IdPSite>(comparator);
                }
                Map<String, IdPSite> theseSites = metadataProvider.getIdPSites(searchName, this.config, search);
                for (int i = 0; i < this.plugins.size(); ++i) {
                    Plugin plugin = this.plugins.get(i);
                    ctx[i] = searchResults == null ? plugin.lookup(req, res, metadataProvider.paramFor(plugin), theseSites, ctx[i], hintList) : plugin.search(req, res, metadataProvider.paramFor(plugin), searchName, theseSites, ctx[i], searchResults, hintList);
                }
                if (null == theseSites || theseSites.isEmpty()) continue;
                TreeSet<IdPSite> values = new TreeSet<IdPSite>(comparator);
                if (null != theseSites) {
                    values.addAll(theseSites.values());
                }
                if (siteLists != null) {
                    siteLists.add(new IdPSiteSetEntry(metadataProvider, values));
                }
                if (sites != null) {
                    sites.addAll(values);
                }
                if (searchResults == null) continue;
                searchResults.addAll(search);
            }
            if (isPassive) {
                if (0 != hintList.size()) {
                    DiscoveryServiceHandler.forwardRequest(req, res, (IdPSite)hintList.get(0));
                } else {
                    DiscoveryServiceHandler.forwardRequest(req, res, null);
                }
                return;
            }
            if (twoZeroProtocol) {
                String returnString = (String)req.getAttribute(RETURN_ATTRIBUTE_NAME);
                if (null == returnString || 0 == returnString.length()) {
                    throw new WayfException("Parameter return not supplied");
                }
                String returnId = DiscoveryServiceHandler.getValue(req, RETURNID_PARAM_NAME);
                if (null == returnId || 0 == returnId.length()) {
                    returnId = "entityID";
                }
                req.setAttribute(RETURN_ATTRIBUTE_NAME, (Object)returnString);
                req.setAttribute(RETURNID_PARAM_NAME, (Object)returnId);
                req.setAttribute("entityID", (Object)providerId);
            } else {
                String target = DiscoveryServiceHandler.getValue(req, TARGET_PARAM_NAME);
                if (null == target || 0 == target.length()) {
                    throw new WayfException("Could not extract target from provided parameters");
                }
                req.setAttribute(SHIRE_PARAM_NAME, (Object)shire);
                req.setAttribute(TARGET_PARAM_NAME, (Object)target);
                req.setAttribute(PROVIDERID_PARAM_NAME, (Object)providerId);
                req.setAttribute(TIME_PARAM_NAME, (Object)new Long(new Date().getTime() / 1000L).toString());
            }
            this.setDisplayLanguage(sites, req);
            req.setAttribute("sites", sites);
            if (null != siteLists) {
                for (IdPSiteSetEntry siteSetEntry : siteLists) {
                    this.setDisplayLanguage(siteSetEntry.getSites(), req);
                }
            }
            req.setAttribute("siteLists", siteLists);
            req.setAttribute("requestURL", (Object)req.getRequestURI().toString());
            if (searchResults != null) {
                if (searchResults.size() != 0) {
                    this.setDisplayLanguage(searchResults, req);
                    req.setAttribute("searchresults", searchResults);
                } else {
                    req.setAttribute("searchResultsEmpty", (Object)"true");
                }
            }
            if (hintList.size() > 0) {
                this.setDisplayLanguage(hintList, req);
                req.setAttribute("cookieList", hintList);
            }
            LOG.debug("Displaying WAYF selection page.");
            RequestDispatcher rd = req.getRequestDispatcher(this.config.getJspFile());
            rd.forward((ServletRequest)req, (ServletResponse)res);
        }
        catch (IOException ioe) {
            LOG.error("Problem displaying WAYF UI.\n" + ioe.getMessage());
            throw new WayfException("Problem displaying WAYF UI", ioe);
        }
        catch (ServletException se) {
            LOG.error("Problem displaying WAYF UI.\n" + se.getMessage());
            throw new WayfException("Problem displaying WAYF UI", se);
        }
    }

    private void setDisplayLanguage(Collection<IdPSite> sites, HttpServletRequest req) {
        if (null == sites) {
            return;
        }
        Locale locale = req.getLocale();
        if (null == locale) {
            Locale.getDefault();
        }
        String lang = locale.getLanguage();
        for (IdPSite site : sites) {
            site.setDisplayLanguage(lang);
        }
    }

    public static void forwardRequest(HttpServletRequest req, HttpServletResponse res, IdPSite site) throws WayfException {
        String redirect;
        boolean twoZeroProtocol;
        String shire = DiscoveryServiceHandler.getValue(req, SHIRE_PARAM_NAME);
        String providerId = DiscoveryServiceHandler.getSPId(req);
        boolean bl = twoZeroProtocol = shire == null;
        if (!twoZeroProtocol) {
            String handleService = site.getAddressForWAYF();
            if (handleService != null) {
                String target = DiscoveryServiceHandler.getValue(req, TARGET_PARAM_NAME);
                if (null == target || 0 == target.length()) {
                    throw new WayfException("Could not extract target from provided parameters");
                }
                LOG.info("Redirecting to selected Handle Service: " + handleService);
                try {
                    StringBuffer buffer = new StringBuffer(handleService + "?" + TARGET_PARAM_NAME + "=");
                    buffer.append(URLEncoder.encode(target, "UTF-8"));
                    buffer.append("&shire=");
                    buffer.append(URLEncoder.encode(shire, "UTF-8"));
                    buffer.append("&providerId=");
                    buffer.append(URLEncoder.encode(providerId, "UTF-8"));
                    buffer.append("&time=");
                    buffer.append(new Long(new Date().getTime() / 1000L).toString());
                    res.sendRedirect(buffer.toString());
                }
                catch (IOException ioe) {
                    throw new WayfException("Error forwarding to IdP: \n" + ioe.getMessage());
                }
            }
            String s = "Error finding to IdP: " + site.getDisplayName(req);
            LOG.error(s);
            throw new WayfException(s);
        }
        String returnUrl = (String)req.getAttribute(RETURN_ATTRIBUTE_NAME);
        if (null == returnUrl || 0 == returnUrl.length()) {
            throw new WayfException("Could not find return parameter");
        }
        try {
            returnUrl = URLDecoder.decode(returnUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WayfException("Did not understand parameter ", e);
        }
        if (site != null) {
            StringBuffer buffer = new StringBuffer(returnUrl);
            String returnParam = DiscoveryServiceHandler.getValue(req, RETURNID_PARAM_NAME);
            if (null == returnParam || 0 == returnParam.length()) {
                returnParam = "entityID";
            }
            if (returnUrl.indexOf(63) >= 0) {
                buffer.append("&" + returnParam + "=");
            } else {
                buffer.append("?" + returnParam + "=");
            }
            buffer.append(site.getName());
            redirect = buffer.toString();
        } else {
            redirect = returnUrl;
        }
        LOG.debug("Dispatching to " + redirect);
        try {
            res.sendRedirect(redirect);
        }
        catch (IOException ioe) {
            throw new WayfException("Error forwarding back to Sp: \n" + ioe.getMessage());
        }
    }

    private void handleError(HttpServletRequest req, HttpServletResponse res, String message) {
        LOG.debug("Displaying WAYF error page.");
        req.setAttribute("errorText", (Object)message);
        req.setAttribute("requestURL", (Object)req.getRequestURI().toString());
        RequestDispatcher rd = req.getRequestDispatcher(this.config.getErrorJspFile());
        try {
            rd.forward((ServletRequest)req, (ServletResponse)res);
        }
        catch (IOException ioe) {
            LOG.error("Problem trying to display WAYF error page: " + ioe.toString());
        }
        catch (ServletException se) {
            LOG.error("Problem trying to display WAYF error page: " + se.toString());
        }
    }

    private static String getValue(HttpServletRequest req, String name) {
        String value = req.getParameter(name);
        if (value != null) {
            return value;
        }
        return (String)req.getAttribute(name);
    }

    private static String getSPId(HttpServletRequest req) throws WayfException {
        String param = req.getParameter("entityID");
        if (param != null && param.length() != 0) {
            return param;
        }
        param = (String)req.getAttribute("entityID");
        if (param != null && param.length() != 0) {
            return param;
        }
        param = req.getParameter(PROVIDERID_PARAM_NAME);
        if (param != null && param.length() != 0) {
            return param;
        }
        param = (String)req.getAttribute(PROVIDERID_PARAM_NAME);
        if (param != null && param.length() != 0) {
            return param;
        }
        throw new WayfException("Could not locate SP identifier in parameters");
    }
}

