/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf;

import edu.internet2.middleware.shibboleth.common.ShibbolethConfigurationException;
import edu.internet2.middleware.shibboleth.wayf.HandlerConfig;
import edu.internet2.middleware.shibboleth.wayf.IdPSite;
import edu.internet2.middleware.shibboleth.wayf.WayfException;
import edu.internet2.middleware.shibboleth.wayf.plugins.Plugin;
import edu.internet2.middleware.shibboleth.wayf.plugins.PluginMetadataParameter;
import edu.internet2.middleware.shibboleth.wayf.plugins.provider.BindingFilter;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml2.metadata.OrganizationName;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.FileBackedHTTPMetadataProvider;
import org.opensaml.saml2.metadata.provider.FilesystemMetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.saml2.metadata.provider.MetadataFilterChain;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.saml2.metadata.provider.MetadataProviderException;
import org.opensaml.saml2.metadata.provider.ObservableMetadataProvider;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.ParserPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdPSiteSet
implements ObservableMetadataProvider.Observer {
    private static final Logger LOG = LoggerFactory.getLogger((String)IdPSiteSet.class.getName());
    private ObservableMetadataProvider metadata;
    private Set<String> spNames = new HashSet<String>(0);
    private Set<String> idpNames = new HashSet<String>(0);
    private final String identifier;
    private final String displayName;
    private String location;
    private final Map<Plugin, PluginMetadataParameter> plugins = new HashMap<Plugin, PluginMetadataParameter>();

    protected IdPSiteSet(Element el, ParserPool parserPool, boolean warnOnBadBinding) throws ShibbolethConfigurationException {
        this.identifier = el.getAttribute("identifier");
        this.displayName = el.getAttribute("displayName");
        this.location = el.getAttribute("url");
        if (null == this.location || this.location.length() == 0) {
            this.location = el.getAttribute("url");
        }
        String spoolSpace = el.getAttribute("backingFile");
        String delayString = el.getAttribute("timeout");
        String ident = "<not specified>";
        String className = "<not specified>";
        MetadataFilterChain filterChain = null;
        filterChain = new MetadataFilterChain();
        try {
            NodeList itemElements = el.getElementsByTagNameNS("urn:mace:shibboleth:wayf:config:1.0", "Filter");
            ArrayList<BindingFilter> filters = new ArrayList<BindingFilter>(1 + itemElements.getLength());
            filters.add(new BindingFilter(warnOnBadBinding));
            for (int i = 0; i < itemElements.getLength(); ++i) {
                Element element = (Element)itemElements.item(i);
                ident = "<not specified>";
                className = "<not specified>";
                ident = element.getAttribute("identifier");
                if (null == ident || ident.equals("")) {
                    LOG.error("Could not load filter with no identifier");
                    continue;
                }
                className = element.getAttribute("type");
                if (null == className || className.equals("")) {
                    LOG.error("Filter " + this.identifier + " did not have a valid type");
                }
                Class<?> filterClass = Class.forName(className);
                Class[] classParams = new Class[]{Element.class};
                Constructor<?> constructor = filterClass.getConstructor(classParams);
                Object[] constructorParams = new Object[]{element};
                filters.add((BindingFilter)constructor.newInstance(constructorParams));
            }
            filterChain.setFilters(filters);
        }
        catch (Exception e) {
            LOG.error("Could not load filter " + ident + "()" + className + ") for " + this.identifier, (Throwable)e);
            throw new ShibbolethConfigurationException("Could not load filter", e);
        }
        LOG.info("Loading Metadata for " + this.displayName);
        try {
            URL url;
            int delay = 30000;
            if (null != delayString && !"".equals(delayString)) {
                delay = Integer.parseInt(delayString);
            }
            if ("file".equalsIgnoreCase((url = new URL(this.location)).getProtocol())) {
                FilesystemMetadataProvider provider = new FilesystemMetadataProvider(new File(url.getFile()));
                provider.setParserPool(parserPool);
                if (null != filterChain) {
                    provider.setMetadataFilter((MetadataFilter)filterChain);
                }
                provider.initialize();
                this.metadata = provider;
            } else {
                if (spoolSpace == null || "".equals(spoolSpace)) {
                    throw new ShibbolethConfigurationException("backingFile must be specified for " + this.identifier);
                }
                FileBackedHTTPMetadataProvider provider = new FileBackedHTTPMetadataProvider(this.location, delay, spoolSpace);
                provider.setParserPool(parserPool);
                if (null != filterChain) {
                    provider.setMetadataFilter((MetadataFilter)filterChain);
                }
                provider.initialize();
                this.metadata = provider;
            }
        }
        catch (MetadataProviderException e) {
            throw new ShibbolethConfigurationException("Could not read " + this.location, e);
        }
        catch (NumberFormatException e) {
            throw new ShibbolethConfigurationException("Badly formed timeout " + delayString, e);
        }
        catch (MalformedURLException e) {
            throw new ShibbolethConfigurationException("Badly formed url ", e);
        }
        this.metadata.getObservers().add(this);
        this.onEvent((MetadataProvider)this.metadata);
    }

    private static boolean isMatch(EntityDescriptor entity, String str, HandlerConfig config) {
        StringTokenizer input = new StringTokenizer(str);
        while (input.hasMoreElements()) {
            String currentToken = (String)input.nextElement();
            if (config.isIgnoredForMatch(currentToken)) continue;
            currentToken = currentToken.toLowerCase();
            if (entity.getEntityID().indexOf(currentToken) > -1) {
                return true;
            }
            Organization org = entity.getOrganization();
            if (org == null) continue;
            List orgNames = org.getOrganizationNames();
            for (OrganizationName name : orgNames) {
                if (name.getName().getLocalString().indexOf(currentToken) <= -1) continue;
                return true;
            }
            List orgDisplayNames = org.getDisplayNames();
            for (OrganizationDisplayName name : orgDisplayNames) {
                if (name.getName().getLocalString().indexOf(currentToken) <= -1) continue;
                return true;
            }
        }
        return false;
    }

    protected Map<String, IdPSite> getIdPSites(String searchString, HandlerConfig config, Collection<IdPSite> searchMatches) {
        List entities;
        XMLObject object;
        try {
            object = this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            LOG.error("Metadata for " + this.location + "could not be read", (Throwable)e);
            return null;
        }
        if (object == null) {
            return null;
        }
        if (object instanceof EntityDescriptor) {
            entities = new ArrayList<EntityDescriptor>(1);
            entities.add((EntityDescriptor)object);
        } else if (object instanceof EntitiesDescriptor) {
            EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)object;
            entities = entitiesDescriptor.getEntityDescriptors();
        } else {
            return null;
        }
        TreeMap<String, IdPSite> result = new TreeMap<String, IdPSite>();
        for (EntityDescriptor entity : entities) {
            if (!entity.isValid() || !IdPSiteSet.hasIdPRole(entity)) continue;
            IdPSite site = new IdPSite(entity);
            result.put(site.getName(), site);
            if (searchMatches == null || !IdPSiteSet.isMatch(entity, searchString, config)) continue;
            searchMatches.add(site);
        }
        return result;
    }

    protected String getIdentifier() {
        return this.identifier;
    }

    protected String getDisplayName() {
        return this.displayName;
    }

    protected boolean containsSP(String SPName) {
        XMLObject object;
        if (SPName == null || SPName.length() == 0) {
            return true;
        }
        try {
            object = this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            return false;
        }
        if (object instanceof EntitiesDescriptor || object instanceof EntityDescriptor) {
            return this.spNames.contains(SPName);
        }
        return false;
    }

    protected boolean containsIdP(String IdPName) {
        XMLObject object;
        if (IdPName == null || IdPName.length() == 0) {
            return true;
        }
        try {
            object = this.metadata.getMetadata();
        }
        catch (MetadataProviderException e) {
            return false;
        }
        if (object instanceof EntitiesDescriptor || object instanceof EntityDescriptor) {
            return this.idpNames.contains(IdPName);
        }
        return false;
    }

    protected void addPlugin(Plugin plugin) {
        if (this.plugins.containsKey(plugin)) {
            return;
        }
        PluginMetadataParameter param = plugin.refreshMetadata((MetadataProvider)this.metadata);
        this.plugins.put(plugin, param);
    }

    protected PluginMetadataParameter paramFor(Plugin plugin) {
        return this.plugins.get(plugin);
    }

    public void onEvent(MetadataProvider provider) {
        XMLObject obj;
        HashSet<String> spNameSet = new HashSet<String>(0);
        HashSet<String> idpNameSet = new HashSet<String>(0);
        try {
            obj = provider.getMetadata();
        }
        catch (MetadataProviderException e) {
            LOG.error("Couldn't read metadata for " + this.location, (Throwable)e);
            return;
        }
        if (obj instanceof EntitiesDescriptor) {
            EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)obj;
            for (EntityDescriptor entity : entitiesDescriptor.getEntityDescriptors()) {
                if (IdPSiteSet.hasSPRole(entity)) {
                    spNameSet.add(entity.getEntityID());
                }
                if (!IdPSiteSet.hasIdPRole(entity)) continue;
                idpNameSet.add(entity.getEntityID());
            }
        } else if (obj instanceof EntityDescriptor) {
            EntityDescriptor entity = (EntityDescriptor)obj;
            if (IdPSiteSet.hasSPRole(entity)) {
                spNameSet.add(entity.getEntityID());
            }
            if (IdPSiteSet.hasIdPRole(entity)) {
                idpNameSet.add(entity.getEntityID());
            }
        } else {
            LOG.error("Metadata for " + this.location + " isn't <EntitiesDescriptor> or <EntityDescriptor>");
            return;
        }
        this.spNames = spNameSet;
        this.idpNames = idpNameSet;
        for (Plugin plugin : this.plugins.keySet()) {
            this.plugins.put(plugin, plugin.refreshMetadata(provider));
        }
    }

    private static boolean hasIdPRole(EntityDescriptor entity) {
        List roles = entity.getRoleDescriptors();
        for (RoleDescriptor role : roles) {
            if (!(role instanceof IDPSSODescriptor)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasSPRole(EntityDescriptor entity) {
        List roles = entity.getRoleDescriptors();
        for (RoleDescriptor role : roles) {
            if (!(role instanceof SPSSODescriptor)) continue;
            return true;
        }
        return false;
    }

    protected IdPSite getSite(String idpName) throws WayfException {
        try {
            return new IdPSite(this.metadata.getEntityDescriptor(idpName));
        }
        catch (MetadataProviderException e) {
            String s = "Couldn't resolve " + idpName + " in " + this.getDisplayName();
            LOG.error(s, (Throwable)e);
            throw new WayfException(s, e);
        }
    }

    protected EntityDescriptor getEntity(String name) throws WayfException {
        try {
            return this.metadata.getEntityDescriptor(name);
        }
        catch (MetadataProviderException e) {
            String s = "Couldn't resolve " + name + " in " + this.getDisplayName();
            LOG.error(s, (Throwable)e);
            throw new WayfException(s, e);
        }
    }
}

