/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf.plugins.provider;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ListFilter
implements MetadataFilter {
    private static final Logger LOG = LoggerFactory.getLogger((String)ListFilter.class.getName());
    private boolean excludeEntries;
    private final Set<String> filterEntities;
    private final String filterName;

    private ListFilter() {
        this.excludeEntries = false;
        this.filterEntities = new HashSet<String>(0);
        this.filterName = "anonymous";
    }

    public ListFilter(Element config) {
        this.filterEntities = new HashSet<String>(10);
        this.filterName = config.getAttribute("identifier");
        String excludeEntriesValue = config.getAttribute("excludeEntries");
        this.excludeEntries = null == excludeEntriesValue || 0 == excludeEntriesValue.length() ? true : Boolean.getBoolean(excludeEntriesValue);
        NodeList itemElements = config.getElementsByTagNameNS("urn:mace:shibboleth:wayf:config:1.0", "EntityId");
        if (this.excludeEntries) {
            LOG.debug("Populating blacklist " + this.filterName);
        } else {
            LOG.debug("Populating whitelist " + this.filterName);
        }
        for (int i = 0; i < itemElements.getLength(); ++i) {
            Element element = (Element)itemElements.item(i);
            String entityId = element.getTextContent();
            LOG.debug("\t" + entityId);
            this.filterEntities.add(entityId);
        }
    }

    public void doFilter(XMLObject metadata) throws FilterException {
        if (metadata instanceof EntitiesDescriptor) {
            this.filterEntities((EntitiesDescriptor)metadata);
        } else if (metadata instanceof EntityDescriptor) {
            EntityDescriptor entity = (EntityDescriptor)metadata;
            String entityName = entity.getEntityID();
            if (this.excludeEntries) {
                if (this.filterEntities.contains(entityName)) {
                    LOG.error("Metadata provider contains a single <EntityDescriptor> (" + entityName + ") which is in exclude list");
                }
            } else if (!this.filterEntities.contains(entity.getEntityID())) {
                LOG.error("Metadata provider contains a single <EntityDescriptor>  (" + entityName + ") which is not on include list");
            }
        }
    }

    private void filterEntities(EntitiesDescriptor entities) {
        String entitiesName = entities.getName();
        List childEntities = entities.getEntitiesDescriptors();
        List children = entities.getEntityDescriptors();
        if (children != null) {
            Iterator itr = children.iterator();
            while (itr.hasNext()) {
                EntityDescriptor entity = (EntityDescriptor)itr.next();
                String entityName = entity.getEntityID();
                if (this.excludeEntries) {
                    if (!this.filterEntities.contains(entityName)) continue;
                    LOG.debug("Filter " + this.filterName + ": Removing blacklisted " + entityName + " from " + entitiesName);
                    itr.remove();
                    continue;
                }
                if (this.filterEntities.contains(entityName)) continue;
                LOG.debug("Filter " + this.filterName + ": Removing non-whitelisted " + entityName + " from " + entitiesName);
                itr.remove();
            }
        }
        if (childEntities != null) {
            for (EntitiesDescriptor descriptor : childEntities) {
                this.filterEntities(descriptor);
            }
        }
    }
}

