/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf;

import edu.internet2.middleware.shibboleth.common.ShibbolethConfigurationException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HandlerConfig {
    private static final Logger LOG = LoggerFactory.getLogger((String)HandlerConfig.class.getName());
    private final HashSet<String> ignoredForMatch;
    private final String jspFile;
    private final String errorJspFile;
    private final boolean provideListOfLists;
    private final boolean provideList;
    private final boolean lookupSp;
    private final boolean warnOnBadBinding;

    public HandlerConfig() {
        this.jspFile = "/wayf.jsp";
        this.errorJspFile = "/wayfError.jsp";
        this.provideList = true;
        this.provideListOfLists = false;
        this.lookupSp = true;
        this.ignoredForMatch = new HashSet();
        this.warnOnBadBinding = false;
    }

    public HandlerConfig(Element config, HandlerConfig defaultValue) throws ShibbolethConfigurationException {
        LOG.debug("Loading global configuration properties.");
        NodeList list = config.getElementsByTagName("SearchIgnore");
        if (list.getLength() == 0) {
            this.ignoredForMatch = defaultValue.ignoredForMatch;
        } else {
            this.ignoredForMatch = new HashSet();
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList inner = ((Element)list.item(i)).getElementsByTagName("IgnoreText");
                for (int j = 0; j < inner.getLength(); ++j) {
                    this.addIgnoredForMatch(inner.item(j).getTextContent());
                }
            }
        }
        String attribute = config.getAttribute("jspFile");
        this.jspFile = attribute != null && !attribute.equals("") ? attribute : defaultValue.jspFile;
        attribute = config.getAttribute("errorJspFile");
        this.errorJspFile = attribute != null && !attribute.equals("") ? attribute : defaultValue.errorJspFile;
        attribute = config.getAttribute("provideList");
        this.provideList = attribute != null && !attribute.equals("") ? Boolean.valueOf(attribute) : defaultValue.provideList;
        attribute = config.getAttribute("provideListOfList");
        this.provideListOfLists = attribute != null && !attribute.equals("") ? Boolean.valueOf(attribute) : defaultValue.provideListOfLists;
        attribute = config.getAttribute("showUnusableIdPs");
        this.lookupSp = attribute != null && !attribute.equals("") ? Boolean.valueOf(attribute) == false : defaultValue.lookupSp;
        attribute = config.getAttribute("warnOnBadBinding");
        this.warnOnBadBinding = null != attribute && !attribute.equals("") ? Boolean.valueOf(attribute) : false;
    }

    public boolean isIgnoredForMatch(String str) {
        return this.ignoredForMatch.contains(str.toLowerCase());
    }

    private void addIgnoredForMatch(String s) {
        this.ignoredForMatch.add(s.toLowerCase());
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getErrorJspFile() {
        return this.errorJspFile;
    }

    public boolean getProvideListOfLists() {
        return this.provideListOfLists;
    }

    public boolean getProvideList() {
        return this.provideList;
    }

    public boolean getLookupSp() {
        return this.lookupSp;
    }

    public boolean getWarnOnBadBinding() {
        return this.warnOnBadBinding;
    }
}

