/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml2.metadata.Organization;
import org.opensaml.saml2.metadata.OrganizationDisplayName;
import org.opensaml.saml2.metadata.SingleSignOnService;

public class IdPSite {
    private EntityDescriptor entity;
    private String displayLanguage;

    public IdPSite(EntityDescriptor entityParam) {
        this.entity = entityParam;
    }

    public String getName() {
        return this.entity.getEntityID();
    }

    public String getDisplayName(HttpServletRequest req) {
        Locale locale = req.getLocale();
        if (null == locale) {
            Locale.getDefault();
        }
        String lang = locale.getLanguage();
        return this.getDisplayName(lang);
    }

    private String getDisplayName(String lang) {
        Organization org = this.entity.getOrganization();
        if (org == null) {
            return this.entity.getEntityID();
        }
        List list = org.getDisplayNames();
        for (OrganizationDisplayName name : list) {
            if (null == name || !lang.equals(name.getName().getLanguage())) continue;
            return name.getName().getLocalString();
        }
        for (OrganizationDisplayName name : list) {
            if (null == name || null == name.getName().getLocalString()) continue;
            return name.getName().getLocalString();
        }
        return this.entity.getEntityID();
    }

    public String getDisplayName() {
        return this.getDisplayName(this.displayLanguage);
    }

    public Extensions getExtensions() {
        IDPSSODescriptor idpss = this.entity.getIDPSSODescriptor("urn:mace:shibboleth:1.0");
        if (null == idpss) {
            idpss = this.entity.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol");
        }
        if (null == idpss) {
            return null;
        }
        return idpss.getExtensions();
    }

    protected int compareTo(Object o, HttpServletRequest req) {
        int result;
        IdPSite other;
        String otherDisplayName;
        if (this.equals(o)) {
            return 0;
        }
        String myDisplayName = this.getDisplayName(req);
        if (null == myDisplayName) {
            myDisplayName = "";
        }
        if (null == (otherDisplayName = (other = (IdPSite)o).getDisplayName(req))) {
            otherDisplayName = "";
        }
        if ((result = myDisplayName.toLowerCase().compareTo(otherDisplayName.toLowerCase())) == 0) {
            result = myDisplayName.compareTo(otherDisplayName);
        }
        return result;
    }

    public String getAddressForWAYF() {
        List ssoList = this.entity.getIDPSSODescriptor("urn:mace:shibboleth:1.0").getSingleSignOnServices();
        for (SingleSignOnService signOnService : ssoList) {
            if (!"urn:mace:shibboleth:1.0:profiles:AuthnRequest".equals(signOnService.getBinding())) continue;
            return signOnService.getLocation();
        }
        return null;
    }

    public void setDisplayLanguage(String lang) {
        this.displayLanguage = lang;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Compare
    implements Comparator<IdPSite> {
        private HttpServletRequest req = null;

        private Compare() {
        }

        public Compare(HttpServletRequest req) {
            this.req = req;
        }

        @Override
        public int compare(IdPSite o1, IdPSite o2) {
            return o1.compareTo(o2, this.req);
        }
    }
}

