/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf.plugins.provider;

import java.util.HashSet;
import java.util.List;
import org.opensaml.saml2.common.Extensions;
import org.opensaml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml2.metadata.provider.FilterException;
import org.opensaml.saml2.metadata.provider.MetadataFilter;
import org.opensaml.samlext.idpdisco.DiscoveryResponse;
import org.opensaml.xml.XMLObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BindingFilter
implements MetadataFilter {
    private static final Logger LOG = LoggerFactory.getLogger((String)BindingFilter.class.getName());
    private final boolean warnOnFailure;

    private BindingFilter() {
        this.warnOnFailure = false;
    }

    public BindingFilter(boolean warn) {
        this.warnOnFailure = warn;
    }

    public void doFilter(XMLObject metadata) throws FilterException {
        EntityDescriptor entity;
        if (metadata instanceof EntitiesDescriptor) {
            this.checkEntities((EntitiesDescriptor)metadata);
        } else if (metadata instanceof EntityDescriptor && !BindingFilter.checkEntity(entity = (EntityDescriptor)metadata)) {
            if (this.warnOnFailure) {
                LOG.warn("Badly formatted binding for " + entity.getEntityID());
            } else {
                LOG.error("Badly formatted binding for top level entity " + entity.getEntityID());
            }
        }
    }

    private static boolean checkEntity(EntityDescriptor entity) {
        List roles = entity.getRoleDescriptors();
        for (RoleDescriptor role : roles) {
            Extensions exts;
            if (!(role instanceof SPSSODescriptor) || (exts = role.getExtensions()) == null) continue;
            List children = exts.getOrderedChildren();
            for (XMLObject obj : children) {
                DiscoveryResponse ds;
                String binding;
                if (!(obj instanceof DiscoveryResponse) || "urn:oasis:names:tc:SAML:profiles:SSO:idp-discovery-protocol".equals(binding = (ds = (DiscoveryResponse)obj).getBinding())) continue;
                return false;
            }
        }
        return true;
    }

    private void checkEntities(EntitiesDescriptor entities) {
        List childEntities = entities.getEntitiesDescriptors();
        List children = entities.getEntityDescriptors();
        HashSet<EntityDescriptor> excludes = new HashSet<EntityDescriptor>();
        if (children != null) {
            for (EntityDescriptor entity : children) {
                if (BindingFilter.checkEntity(entity)) continue;
                if (this.warnOnFailure) {
                    LOG.warn("Badly formatted binding for " + entity.getEntityID());
                    continue;
                }
                LOG.error("Badly formatted binding for " + entity.getEntityID() + ". Entity has been removed");
                excludes.add(entity);
            }
            children.removeAll(excludes);
        }
        if (childEntities != null) {
            for (EntitiesDescriptor descriptor : childEntities) {
                this.checkEntities(descriptor);
            }
        }
    }
}

