/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf.plugins.provider;

import edu.internet2.middleware.shibboleth.wayf.DiscoveryServiceHandler;
import edu.internet2.middleware.shibboleth.wayf.IdPSite;
import edu.internet2.middleware.shibboleth.wayf.WayfException;
import edu.internet2.middleware.shibboleth.wayf.plugins.Plugin;
import edu.internet2.middleware.shibboleth.wayf.plugins.PluginContext;
import edu.internet2.middleware.shibboleth.wayf.plugins.PluginMetadataParameter;
import edu.internet2.middleware.shibboleth.wayf.plugins.WayfRequestHandled;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.opensaml.saml2.metadata.provider.MetadataProvider;
import org.opensaml.xml.util.Base64;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlCookiePlugin
implements Plugin {
    private static final String PARAMETER_NAME = "cache";
    private static final String PARAMETER_PERM = "perm";
    private static final String PARAMETER_SESSION = "session";
    private static Logger log = Logger.getLogger((String)SamlCookiePlugin.class.getName());
    private static final String COOKIE_NAME = "_saml_idp";
    private static final int DEFAULT_CACHE_EXPIRATION = 6048000;
    private boolean alwaysFollow;
    private boolean deleteCookie;
    private String cacheDomain;
    private int cacheExpiration;

    public SamlCookiePlugin(Element element) {
        log.info((Object)"New plugin");
        String s = element.getAttribute("alwaysFollow");
        this.alwaysFollow = s != null && !s.equals("") ? Boolean.valueOf(s) : true;
        s = element.getAttribute("deleteCookie");
        this.deleteCookie = s != null && !s.equals("") ? Boolean.valueOf(s) : false;
        s = element.getAttribute("cacheDomain");
        this.cacheDomain = s != null && !s.equals("") ? s : "";
        s = element.getAttribute("cacheExpiration");
        if (s != null && !s.equals("")) {
            try {
                this.cacheExpiration = Integer.parseInt(s);
            }
            catch (NumberFormatException ex) {
                log.error((Object)("Invalid CacheExpiration value - " + s));
                this.cacheExpiration = 6048000;
            }
        } else {
            this.cacheExpiration = 6048000;
        }
    }

    private SamlCookiePlugin() {
        this.alwaysFollow = false;
        this.deleteCookie = false;
        this.cacheExpiration = 6048000;
    }

    @Override
    public PluginContext lookup(HttpServletRequest req, HttpServletResponse res, PluginMetadataParameter parameter, Map<String, IdPSite> validIdps, PluginContext context, List<IdPSite> idpList) throws WayfRequestHandled {
        if (context != null) {
            return context;
        }
        if (this.deleteCookie) {
            SamlCookiePlugin.deleteCookie(req, res);
            return new Context();
        }
        List<String> idps = this.getIdPCookie(req, res, this.cacheDomain).getIdPList();
        for (String idpName : idps) {
            IdPSite idp = validIdps.get(idpName);
            if (idp == null) continue;
            if (this.alwaysFollow) {
                try {
                    DiscoveryServiceHandler.forwardRequest(req, res, idp);
                }
                catch (WayfException e) {
                    // empty catch block
                }
                throw new WayfRequestHandled();
            }
            idpList.add(idp);
        }
        return null;
    }

    @Override
    public PluginMetadataParameter refreshMetadata(MetadataProvider metadata) {
        return null;
    }

    @Override
    public PluginContext search(HttpServletRequest req, HttpServletResponse res, PluginMetadataParameter parameter, String pattern, Map<String, IdPSite> validIdps, PluginContext context, Collection<IdPSite> searchResult, List<IdPSite> idpList) throws WayfRequestHandled {
        return this.lookup(req, res, parameter, validIdps, context, idpList);
    }

    @Override
    public void selected(HttpServletRequest req, HttpServletResponse res, PluginMetadataParameter parameter, String idP) {
        SamlIdPCookie cookie = this.getIdPCookie(req, res, this.cacheDomain);
        String param = req.getParameter(PARAMETER_NAME);
        if (null == param || param.equals("")) {
            return;
        }
        if (param.equalsIgnoreCase(PARAMETER_SESSION)) {
            cookie.addIdPName(idP, -1);
        } else if (param.equalsIgnoreCase(PARAMETER_PERM)) {
            cookie.addIdPName(idP, this.cacheExpiration);
        }
    }

    private static Cookie getCookie(HttpServletRequest req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals(COOKIE_NAME)) continue;
                return cookies[i];
            }
        }
        return null;
    }

    private static void deleteCookie(HttpServletRequest req, HttpServletResponse res) {
        Cookie cookie = SamlCookiePlugin.getCookie(req);
        if (cookie == null) {
            return;
        }
        cookie.setPath("/");
        cookie.setMaxAge(0);
        res.addCookie(cookie);
    }

    private SamlIdPCookie getIdPCookie(HttpServletRequest req, HttpServletResponse res, String domain) {
        Cookie cookie = SamlCookiePlugin.getCookie(req);
        if (cookie == null) {
            return new SamlIdPCookie(req, res, domain);
        }
        return new SamlIdPCookie(cookie.getValue(), req, res, domain);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class SamlIdPCookie {
        private final HttpServletRequest req;
        private final HttpServletResponse res;
        private final String domain;
        private final List<String> idPList = new ArrayList<String>();

        private SamlIdPCookie(String codedData, HttpServletRequest request, HttpServletResponse response, String domainName) {
            String value;
            this.req = request;
            this.res = response;
            this.domain = domainName;
            if (codedData == null || codedData.equals("")) {
                log.info((Object)"Empty cookie");
                return;
            }
            if (codedData.charAt(0) == '\"' && codedData.charAt(codedData.length() - 1) == '\"') {
                codedData = codedData.substring(1, codedData.length() - 1);
            }
            try {
                codedData = URLDecoder.decode(codedData, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"could not decode cookie");
                return;
            }
            int start = 0;
            int end = codedData.indexOf(32, start);
            while (end > 0) {
                value = codedData.substring(start, end);
                start = end + 1;
                end = codedData.indexOf(32, start);
                if (value.equals("")) continue;
                this.idPList.add(new String(Base64.decode((String)value)));
            }
            if (start < codedData.length() && !(value = codedData.substring(start)).equals("")) {
                this.idPList.add(new String(Base64.decode((String)value)));
            }
        }

        private SamlIdPCookie(HttpServletRequest request, HttpServletResponse response, String domainName) {
            this.req = request;
            this.res = response;
            this.domain = domainName;
        }

        private void addIdPName(String idPName, int expiration) {
            this.idPList.remove(idPName);
            this.idPList.add(0, idPName);
            this.writeCookie(expiration);
        }

        public void deleteIdPName(String origin, int expiration) {
            this.idPList.remove(origin);
            this.writeCookie(expiration);
        }

        private void writeCookie(int expiration) {
            String value;
            Cookie cookie = SamlCookiePlugin.getCookie(this.req);
            if (this.idPList.size() == 0) {
                cookie.setPath("/");
                cookie.setMaxAge(0);
                this.res.addCookie(cookie);
                return;
            }
            StringBuffer buffer = new StringBuffer();
            for (String next : this.idPList) {
                String what = new String(Base64.encodeBytes((byte[])next.getBytes()));
                buffer.append(what).append(' ');
            }
            try {
                value = URLEncoder.encode(buffer.toString(), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)"Could not encode cookie");
                return;
            }
            if (cookie == null) {
                cookie = new Cookie(SamlCookiePlugin.COOKIE_NAME, value);
            } else {
                cookie.setValue(value);
            }
            cookie.setComment("Used to cache selection of a user's Shibboleth IdP");
            cookie.setPath("/");
            cookie.setMaxAge(expiration);
            if (this.domain != null && this.domain != "") {
                cookie.setDomain(this.domain);
            }
            this.res.addCookie(cookie);
        }

        public List<String> getIdPList() {
            return this.idPList;
        }
    }

    private static class Context
    implements PluginContext {
        private Context() {
        }
    }
}

