/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.security;

import java.security.KeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import org.opensaml.xml.security.SecurityHelper;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.keyinfo.KeyInfoCredentialResolver;

public final class SecurityTestHelper {
    private SecurityTestHelper() {
    }

    public static X509Certificate buildJavaX509Cert(String base64Cert) throws CertificateException {
        return SecurityHelper.buildJavaX509Cert(base64Cert);
    }

    public static X509CRL buildJavaX509CRL(String base64CRL) throws CertificateException, CRLException {
        return SecurityHelper.buildJavaX509CRL(base64CRL);
    }

    public static DSAPublicKey buildJavaDSAPublicKey(String base64EncodedKey) throws KeyException {
        return SecurityHelper.buildJavaDSAPublicKey(base64EncodedKey);
    }

    public static RSAPublicKey buildJavaRSAPublicKey(String base64EncodedKey) throws KeyException {
        return SecurityHelper.buildJavaRSAPublicKey(base64EncodedKey);
    }

    public static RSAPrivateKey buildJavaRSAPrivateKey(String base64EncodedKey) throws KeyException {
        return SecurityHelper.buildJavaRSAPrivateKey(base64EncodedKey);
    }

    public static DSAPrivateKey buildJavaDSAPrivateKey(String base64EncodedKey) throws KeyException {
        return SecurityHelper.buildJavaDSAPrivateKey(base64EncodedKey);
    }

    public static PrivateKey buildJavaPrivateKey(String base64EncodedKey) throws KeyException {
        return SecurityHelper.buildJavaPrivateKey(base64EncodedKey);
    }

    public static PublicKey buildKey(KeySpec keySpec, String keyAlgorithm) throws KeyException {
        return SecurityHelper.buildKey(keySpec, keyAlgorithm);
    }

    public static SecretKey generateKeyFromURI(String algoURI) throws NoSuchAlgorithmException, NoSuchProviderException {
        return SecurityHelper.generateKeyFromURI(algoURI);
    }

    public static KeyPair generateKeyPairFromURI(String algoURI, int keyLength) throws NoSuchAlgorithmException, NoSuchProviderException {
        return SecurityHelper.generateKeyPairFromURI(algoURI, keyLength);
    }

    public static SecretKey generateKey(String algo, int keyLength, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return SecurityHelper.generateKey(algo, keyLength, provider);
    }

    public static KeyPair generateKeyPair(String algo, int keyLength, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        return SecurityHelper.generateKeyPair(algo, keyLength, provider);
    }

    public static Credential generateKeyAndCredential(String algorithmURI) throws NoSuchAlgorithmException, NoSuchProviderException {
        return SecurityHelper.generateKeyAndCredential(algorithmURI);
    }

    public static Credential generateKeyPairAndCredential(String algorithmURI, int keyLength, boolean includePrivate) throws NoSuchAlgorithmException, NoSuchProviderException {
        return SecurityHelper.generateKeyPairAndCredential(algorithmURI, keyLength, includePrivate);
    }

    public static KeyInfoCredentialResolver buildBasicInlineKeyInfoResolver() {
        return SecurityHelper.buildBasicInlineKeyInfoResolver();
    }
}

