/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xml.signature.validator;

import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureSchemaValidator
implements Validator<Signature> {
    @Override
    public void validate(Signature xmlObject) throws ValidationException {
        this.validateSignatureMethod(xmlObject);
        this.validateCanonicalizationMethod(xmlObject);
    }

    protected void validateCanonicalizationMethod(Signature xmlObject) throws ValidationException {
        if (DatatypeHelper.isEmpty(xmlObject.getCanonicalizationAlgorithm())) {
            throw new ValidationException("The CanonicalizationMethod value was empty");
        }
    }

    protected void validateSignatureMethod(Signature xmlObject) throws ValidationException {
        if (DatatypeHelper.isEmpty(xmlObject.getSignatureAlgorithm())) {
            throw new ValidationException("The SignatureMethod value was empty");
        }
    }
}

