/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.common.binding.artifact;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.util.storage.AbstractExpiringObject;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLRuntimeException;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.parse.XMLParserException;
import org.opensaml.xml.util.XMLObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicSAMLArtifactMapEntry
extends AbstractExpiringObject
implements SAMLArtifactMap.SAMLArtifactMapEntry {
    private static final long serialVersionUID = 1577232740330721369L;
    private Logger log = LoggerFactory.getLogger(BasicSAMLArtifactMapEntry.class);
    private String artifact;
    private String issuer;
    private String relyingParty;
    private transient SAMLObject message;
    private String serializedMessage;

    public BasicSAMLArtifactMapEntry(String samlArtifact, String issuerId, String relyingPartyId, String serializedSAML, long lifetime) {
        super(new DateTime().plus(lifetime));
        this.artifact = samlArtifact;
        this.issuer = issuerId;
        this.relyingParty = relyingPartyId;
        this.serializedMessage = serializedSAML;
    }

    public BasicSAMLArtifactMapEntry(String samlArtifact, String issuerId, String relyingPartyId, SAMLObject samlMessage, long lifetime) {
        super(new DateTime().plus(lifetime));
        this.artifact = samlArtifact;
        this.issuer = issuerId;
        this.relyingParty = relyingPartyId;
        this.message = samlMessage;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getIssuerId() {
        return this.issuer;
    }

    public String getRelyingPartyId() {
        return this.relyingParty;
    }

    public SAMLObject getSamlMessage() {
        return this.message;
    }

    void setSAMLMessage(SAMLObject saml) {
        this.message = saml;
        this.serializedMessage = null;
    }

    String getSeralizedMessage() {
        return this.getSerializedMessage();
    }

    String getSerializedMessage() {
        return this.serializedMessage;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(BasicSAMLArtifactMapEntry.class);
        }
        this.log.debug("Serializing object data to ObjectOutputStream");
        if (this.serializedMessage == null) {
            this.log.debug("Serializing SAMLObject to a string");
            StringWriter writer = new StringWriter();
            try {
                XMLObjectHelper.marshallToWriter((XMLObject)this.message, (Writer)writer);
            }
            catch (MarshallingException e) {
                throw new XMLRuntimeException("Error marshalling the SAMLObject: " + e.getMessage());
            }
            this.serializedMessage = writer.toString();
            if (this.log.isTraceEnabled()) {
                this.log.trace("Serialized SAMLObject data was:");
                this.log.trace(this.serializedMessage);
            }
        } else {
            this.log.debug("SAMLObject was already serialized, skipping marshall and serialize step");
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(BasicSAMLArtifactMapEntry.class);
        }
        this.log.debug("Deserializing object data from ObjectInputStream");
        in.defaultReadObject();
        ParserPool parserPool = Configuration.getParserPool();
        if (parserPool == null) {
            throw new XMLRuntimeException("No ParserPool was available for parsing the deserialized artifact map entry");
        }
        StringReader reader = new StringReader(this.getSerializedMessage());
        try {
            SAMLObject samlObject = (SAMLObject)XMLObjectHelper.unmarshallFromReader((ParserPool)parserPool, (Reader)reader);
            this.setSAMLMessage(samlObject);
        }
        catch (XMLParserException e) {
            throw new IOException("Error parsing XML into DOM: " + e.getMessage());
        }
        catch (UnmarshallingException e) {
            throw new IOException("Error unmarshalling DOM into SAMLObject: " + e.getMessage());
        }
    }
}

