/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Unpack;
import org.apache.tools.ant.util.FileUtils;

public class GUnzip
extends Unpack {
    private static final String DEFAULT_EXTENSION = ".gz";
    static /* synthetic */ Class class$org$apache$tools$ant$taskdefs$GUnzip;

    protected String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    protected void extract() {
        if (this.source.lastModified() > this.dest.lastModified()) {
            this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
            FileOutputStream out = null;
            GZIPInputStream zIn = null;
            InputStream fis = null;
            try {
                out = new FileOutputStream(this.dest);
                fis = this.srcResource.getInputStream();
                zIn = new GZIPInputStream(fis);
                byte[] buffer = new byte[8192];
                int count = 0;
                do {
                    out.write(buffer, 0, count);
                } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
            }
            catch (IOException ioe) {
                try {
                    String msg = "Problem expanding gzip " + ioe.getMessage();
                    throw new BuildException(msg, ioe, this.getLocation());
                }
                catch (Throwable throwable) {
                    FileUtils.close(fis);
                    FileUtils.close(out);
                    FileUtils.close(zIn);
                    throw throwable;
                }
            }
            FileUtils.close(fis);
            FileUtils.close(out);
            FileUtils.close(zIn);
        }
    }

    protected boolean supportsNonFileResources() {
        return this.getClass().equals(class$org$apache$tools$ant$taskdefs$GUnzip == null ? (class$org$apache$tools$ant$taskdefs$GUnzip = GUnzip.class$("org.apache.tools.ant.taskdefs.GUnzip")) : class$org$apache$tools$ant$taskdefs$GUnzip);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

