/*
 * Copyright 2010 University Corporation for Advanced Internet Development, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package edu.internet2.middleware.shibboleth.wayf.idpdisco;

import org.opensaml.common.impl.AbstractSAMLObjectBuilder;

/**
 * Builder of {@link edu.internet2.middleware.shibboleth.wayf.idpdisco.IPHint} objects.
 */
public class IPHintBuilder extends AbstractSAMLObjectBuilder<IPHint> {

    /**
     * Constructor.
     */
    public IPHintBuilder() {

    }

    /** {@inheritDoc} */
    public IPHint buildObject() {
        return buildObject(DiscoHints.MDUI_NS, 
                           IPHint.DEFAULT_ELEMENT_LOCAL_NAME, 
                           DiscoHints.MDUI_PREFIX);
    }

    /** {@inheritDoc} */
    public IPHint buildObject(String namespaceURI, String localName, String namespacePrefix) {
        return new IPHintImpl(namespaceURI, localName, namespacePrefix);
    }
}