/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf;

import edu.internet2.middleware.shibboleth.common.ShibbolethConfigurationException;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HandlerConfig {
    private static final Logger LOG = LoggerFactory.getLogger((String)HandlerConfig.class.getName());
    private final HashSet<String> ignoredForMatch;
    private final String jspFile;
    private final String errorJspFile;
    private final boolean provideListOfLists;
    private final boolean provideList;
    private final boolean lookupSp;
    private final boolean warnOnBadBinding;
    private final boolean warnOnNoSAML2;

    public HandlerConfig() {
        this.jspFile = "/wayf.jsp";
        this.errorJspFile = "/wayfError.jsp";
        this.provideList = true;
        this.provideListOfLists = false;
        this.lookupSp = true;
        this.ignoredForMatch = new HashSet();
        this.warnOnBadBinding = false;
        this.warnOnNoSAML2 = false;
    }

    public HandlerConfig(Element config, HandlerConfig defaultValue) throws ShibbolethConfigurationException {
        LOG.debug("Loading global configuration properties.");
        NodeList list = config.getElementsByTagName("SearchIgnore");
        if (list.getLength() == 0) {
            this.ignoredForMatch = defaultValue.ignoredForMatch;
        } else {
            this.ignoredForMatch = new HashSet();
            for (int i = 0; i < list.getLength(); ++i) {
                NodeList inner = ((Element)list.item(i)).getElementsByTagName("IgnoreText");
                for (int j = 0; j < inner.getLength(); ++j) {
                    this.addIgnoredForMatch(inner.item(j).getTextContent());
                }
            }
        }
        this.jspFile = this.lookupElement(config, "jspFile", defaultValue.jspFile);
        this.errorJspFile = this.lookupElement(config, "errorJspFile", defaultValue.errorJspFile);
        this.provideList = this.lookupElement(config, "provideList", defaultValue.provideList);
        this.provideListOfLists = this.lookupElement(config, "provideListOfList", defaultValue.provideListOfLists);
        this.lookupSp = !this.lookupElement(config, "showUnusableIdPs", !defaultValue.lookupSp);
        this.warnOnBadBinding = this.lookupElement(config, "warnOnBadBinding", defaultValue.warnOnBadBinding);
        this.warnOnNoSAML2 = this.lookupElement(config, "warnOnNoSAML2", defaultValue.warnOnNoSAML2);
    }

    private boolean lookupElement(Element element, String attributeName, boolean defaultValue) {
        String val = element.getAttribute(attributeName);
        if (val != null && !val.isEmpty()) {
            return Boolean.valueOf(val);
        }
        return defaultValue;
    }

    private String lookupElement(Element element, String attributeName, String defaultValue) {
        String val = element.getAttribute(attributeName);
        if (val != null && !val.isEmpty()) {
            return val;
        }
        return defaultValue;
    }

    public boolean isIgnoredForMatch(String str) {
        return this.ignoredForMatch.contains(str.toLowerCase());
    }

    private void addIgnoredForMatch(String s) {
        this.ignoredForMatch.add(s.toLowerCase());
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public String getErrorJspFile() {
        return this.errorJspFile;
    }

    public boolean getProvideListOfLists() {
        return this.provideListOfLists;
    }

    public boolean getProvideList() {
        return this.provideList;
    }

    public boolean getLookupSp() {
        return this.lookupSp;
    }

    public boolean getWarnOnBadBinding() {
        return this.warnOnBadBinding;
    }

    public boolean getwarnOnNoSAML2() {
        return this.warnOnNoSAML2;
    }
}

