/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import org.opensaml.util.resource.Resource;
import org.opensaml.util.resource.ResourceChangeListener;
import org.opensaml.util.resource.ResourceException;
import org.slf4j.LoggerFactory;

public class LogbackConfigurationChangeListener
implements ResourceChangeListener {
    public void onResourceCreate(Resource resource) {
        this.configureLogback(resource);
    }

    public void onResourceDelete(Resource resource) {
    }

    public void onResourceUpdate(Resource resource) {
        this.configureLogback(resource);
    }

    protected void configureLogback(Resource configuration) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        StatusManager statusManager = loggerContext.getStatusManager();
        statusManager.add((Status)new InfoStatus("Loading logging configuration file: " + configuration.getLocation(), (Object)this));
        try {
            loggerContext.reset();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)loggerContext);
            configurator.doConfigure(configuration.getInputStream());
            loggerContext.start();
        }
        catch (JoranException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + configuration.getLocation(), (Object)this, (Throwable)e));
        }
        catch (ResourceException e) {
            statusManager.add((Status)new ErrorStatus("Error loading logging configuration file: " + configuration.getLocation(), (Object)this, (Throwable)e));
        }
    }
}

