/*
 * Decompiled with CFR 0.152.
 */
package edu.internet2.middleware.shibboleth.wayf;

import edu.internet2.middleware.shibboleth.common.ShibbolethConfigurationException;
import edu.internet2.middleware.shibboleth.wayf.DiscoveryServiceHandler;
import edu.internet2.middleware.shibboleth.wayf.HandlerConfig;
import edu.internet2.middleware.shibboleth.wayf.IdPSiteSet;
import edu.internet2.middleware.shibboleth.wayf.LogbackLoggingService;
import edu.internet2.middleware.shibboleth.wayf.plugins.Plugin;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.DefaultBootstrap;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.parse.ParserPool;
import org.opensaml.xml.util.DatatypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WayfService
extends HttpServlet {
    private static final long serialVersionUID = 5244503011625804940L;
    private static final Logger LOG = LoggerFactory.getLogger((String)WayfService.class.getName());
    private String wayfConfigFileLocation;
    private LogbackLoggingService logService;
    private List<DiscoveryServiceHandler> discoveryServices = new ArrayList<DiscoveryServiceHandler>();

    public void init() throws ServletException {
        super.init();
        this.wayfConfigFileLocation = this.getServletContext().getInitParameter("WAYFConfigFileLocation");
        if (this.wayfConfigFileLocation == null) {
            this.wayfConfigFileLocation = this.getServletConfig().getInitParameter("WAYFConfigFileLocation");
        }
        if (this.wayfConfigFileLocation == null) {
            this.wayfConfigFileLocation = "/wayfconfig.xml";
        }
        try {
            int i;
            HandlerConfig defaultHandlerConfig;
            Document doc;
            String wayfLogfile = this.getServletContext().getInitParameter("WAYFLogConfig");
            if (null == wayfLogfile) {
                wayfLogfile = this.getServletConfig().getInitParameter("WAYFLogConfig");
            }
            long pollingFrequency = 300000L;
            String wayfLogfilePollFrequency = this.getServletContext().getInitParameter("WAYFLogConfigPollFrequency");
            if (null == wayfLogfilePollFrequency) {
                wayfLogfilePollFrequency = this.getServletConfig().getInitParameter("WAYFLogConfigPollFrequency");
            }
            if (!DatatypeHelper.isEmpty((String)wayfLogfilePollFrequency)) {
                pollingFrequency = Long.parseLong(wayfLogfilePollFrequency);
            }
            if (wayfLogfile != null) {
                this.logService = new LogbackLoggingService(wayfLogfile, pollingFrequency);
            }
            LOG.info("Logging initiated");
            DefaultBootstrap.bootstrap();
            BasicParserPool parser = new BasicParserPool();
            parser.setNamespaceAware(true);
            try {
                doc = parser.parse((InputStream)new FileInputStream(this.wayfConfigFileLocation));
            }
            catch (FileNotFoundException e) {
                LOG.error("Could not parse " + this.wayfConfigFileLocation, (Throwable)e);
                throw new ShibbolethConfigurationException("Could not parse " + this.wayfConfigFileLocation, e);
            }
            NodeList itemElements = doc.getDocumentElement().getElementsByTagNameNS("urn:mace:shibboleth:wayf:config:1.0", "Default");
            if (itemElements.getLength() == 1) {
                Element element = (Element)itemElements.item(0);
                String attribute = element.getAttribute("location");
                if (attribute != null && !attribute.isEmpty()) {
                    LOG.error("<Default> element cannot contain a location attribute");
                    throw new ShibbolethConfigurationException("<Default> element cannot contain a location attribute");
                }
                attribute = element.getAttribute("default");
                if (attribute != null && !attribute.isEmpty()) {
                    LOG.error("<Default> element cannot contain a default attribute");
                    throw new ShibbolethConfigurationException("<Default> element cannot contain a default attribute");
                }
                itemElements = element.getElementsByTagName("Federation");
                if (itemElements.getLength() != 0) {
                    LOG.error("<Default> element cannot contain <Federation> elements");
                    throw new ShibbolethConfigurationException("<Default> element cannot contain <Federation> elements");
                }
                defaultHandlerConfig = new HandlerConfig(element, new HandlerConfig());
            } else if (itemElements.getLength() == 0) {
                defaultHandlerConfig = new HandlerConfig();
            } else {
                LOG.error("Must specify exactly one <Default> element");
                throw new ShibbolethConfigurationException("Must specify exactly one <Default> element");
            }
            HashMap<String, IdPSiteSet> siteSets = new HashMap<String, IdPSiteSet>();
            itemElements = doc.getDocumentElement().getElementsByTagNameNS("urn:mace:shibboleth:wayf:config:1.0", "MetadataProvider");
            for (int i2 = 0; i2 < itemElements.getLength(); ++i2) {
                Element element = (Element)itemElements.item(i2);
                IdPSiteSet siteSet = new IdPSiteSet(element, (ParserPool)parser, defaultHandlerConfig.getWarnOnBadBinding());
                if (siteSets.containsKey(siteSet.getIdentifier())) {
                    LOG.warn("Duplicate Metadata provider: " + siteSet.getIdentifier());
                    continue;
                }
                siteSets.put(siteSet.getIdentifier(), siteSet);
            }
            if (siteSets.size() < 1) {
                LOG.error("No Metadata Provider metadata loaded.");
                throw new ShibbolethConfigurationException("Could not load SAML metadata.");
            }
            HashMap<String, Plugin> plugins = new HashMap<String, Plugin>();
            itemElements = doc.getDocumentElement().getElementsByTagNameNS("urn:mace:shibboleth:wayf:config:1.0", "Plugin");
            for (i = 0; i < itemElements.getLength(); ++i) {
                Plugin plugin;
                Element element = (Element)itemElements.item(i);
                String identifier = element.getAttribute("identifier");
                if (null == identifier || identifier.isEmpty()) {
                    LOG.error("Could not load plugin with no identifier");
                    continue;
                }
                String className = element.getAttribute("type");
                if (null == className || className.isEmpty()) {
                    LOG.error("Plugin " + identifier + " did not have a valid type");
                }
                try {
                    Class<?> pluginClass = Class.forName(className);
                    Class[] classParams = new Class[]{Element.class};
                    Constructor<?> pluginConstructor = pluginClass.getConstructor(classParams);
                    Object[] constructorParams = new Object[]{element};
                    plugin = (Plugin)pluginConstructor.newInstance(constructorParams);
                }
                catch (Exception e) {
                    LOG.error("Plugin " + identifier + " could not be loaded ", (Throwable)e);
                    continue;
                }
                plugins.put(identifier, plugin);
            }
            itemElements = doc.getDocumentElement().getElementsByTagNameNS("urn:mace:shibboleth:wayf:config:1.0", "DiscoveryServiceHandler");
            for (i = 0; i < itemElements.getLength(); ++i) {
                this.discoveryServices.add(new DiscoveryServiceHandler((Element)itemElements.item(i), siteSets, plugins, defaultHandlerConfig));
            }
        }
        catch (Exception e) {
            if (LOG != null) {
                LOG.error("Error parsing DS configuration file.", (Throwable)e);
            }
            throw new ServletException("Error parsing DS configuration file.", (Throwable)e);
        }
        LOG.info("DS initialization completed.");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) {
        LOG.info("Handling DS request.");
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("Pragma", "no-cache");
        res.setDateHeader("Expires", 0L);
        DiscoveryServiceHandler serviceHandler = this.lookupServiceHandler(req);
        serviceHandler.doGet(req, res);
    }

    private DiscoveryServiceHandler lookupServiceHandler(HttpServletRequest req) {
        Iterator<DiscoveryServiceHandler> it = this.discoveryServices.iterator();
        String requestURL = req.getRequestURL().toString();
        DiscoveryServiceHandler defaultHandler = null;
        while (it.hasNext()) {
            DiscoveryServiceHandler handler = it.next();
            if (requestURL.matches(handler.getLocation())) {
                return handler;
            }
            if (defaultHandler != null && !handler.isDefault()) continue;
            defaultHandler = handler;
        }
        LOG.warn("Could not find Discovery service Handler for " + requestURL);
        return defaultHandler;
    }
}

