/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerBuilder;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerPermission;
import javax.management.MalformedObjectNameException;
import javax.management.loading.ClassLoaderRepository;
import org.jboss.mx.server.ServerConfig;

public class MBeanServerFactory {
    private static final MBeanServerPermission CREATE = new MBeanServerPermission("createMBeanServer", null);
    private static final MBeanServerPermission FIND = new MBeanServerPermission("findMBeanServer", null);
    private static final MBeanServerPermission NEW = new MBeanServerPermission("newMBeanServer", null);
    private static final MBeanServerPermission RELEASE = new MBeanServerPermission("releaseMBeanServer", null);
    private static Map serverMap = new HashMap();
    private static ServerConfig serverConfig = ServerConfig.getInstance();

    private MBeanServerFactory() {
    }

    public static void releaseMBeanServer(MBeanServer mbeanServer) {
        MBeanServerFactory.checkPermission(RELEASE);
        try {
            String agentID = null;
            final MBeanServer theServer = mbeanServer;
            try {
                agentID = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return (String)theServer.getAttribute(serverConfig.getMBeanServerDelegateName(), "MBeanServerId");
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof JMException) {
                    throw (JMException)ex;
                }
                if (ex instanceof RuntimeException) {
                    throw (RuntimeException)ex;
                }
                JMException jex = new JMException("Unknown exception during getAttribute(MBeanServerId)");
                jex.initCause(ex);
                throw jex;
            }
            Object server = serverMap.remove(agentID);
            try {
                Method m = server.getClass().getMethod("releaseServer", null);
                m.invoke(server, (Object[])null);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            if (server == null) {
                throw new IllegalArgumentException("MBean server reference not found.");
            }
        }
        catch (MalformedObjectNameException e) {
            throw new Error(e.toString());
        }
        catch (JMException e) {
            throw new Error("Cannot retrieve AgentID: " + e.toString());
        }
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer(serverConfig.getDefaultDomain());
    }

    public static MBeanServer createMBeanServer(String domain) {
        MBeanServerFactory.checkPermission(CREATE);
        return MBeanServerFactory.createMBeanServer(domain, true);
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer(serverConfig.getDefaultDomain());
    }

    public static MBeanServer newMBeanServer(String domain) {
        MBeanServerFactory.checkPermission(NEW);
        return MBeanServerFactory.createMBeanServer(domain, false);
    }

    public static synchronized ArrayList findMBeanServer(String agentId) {
        MBeanServerFactory.checkPermission(FIND);
        if (agentId != null) {
            ArrayList list2 = new ArrayList(1);
            Object server = serverMap.get(agentId);
            if (server != null) {
                list2.add(server);
            }
            return list2;
        }
        return new ArrayList(serverMap.values());
    }

    public static ClassLoaderRepository getClassLoaderRepository(MBeanServer server) {
        return server.getClassLoaderRepository();
    }

    private static MBeanServer createMBeanServer(final String defaultDomain, boolean registerServer) {
        final MBeanServerBuilder builder = serverConfig.getMBeanServerBuilder();
        final MBeanServerDelegate delegate = builder.newMBeanServerDelegate();
        MBeanServer server = null;
        try {
            server = (MBeanServer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return builder.newMBeanServer(defaultDomain, null, delegate);
                }
            });
        }
        catch (PrivilegedActionException e) {
            RuntimeException re = (RuntimeException)e.getException();
            throw re;
        }
        if (registerServer) {
            String agentID = delegate.getMBeanServerId();
            serverMap.put(agentID, server);
        }
        return server;
    }

    private static void checkPermission(MBeanServerPermission permission) {
        SecurityManager security = System.getSecurityManager();
        if (security == null) {
            return;
        }
        security.checkPermission(permission);
    }
}

