/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;

public class MBeanServerPermission
extends BasicPermission {
    private static final long serialVersionUID = -5661980843569388590L;
    private transient boolean allNames;

    public MBeanServerPermission(String name) {
        this(name, null);
    }

    public MBeanServerPermission(String name, String actions) {
        super(name, actions);
        this.init(name, actions);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(this.getClass().getName()).append(":");
        buffer.append(" name=").append(this.getName());
        buffer.append(" actions=").append(this.getActions());
        return buffer.toString();
    }

    public boolean implies(Permission p) {
        String n1;
        String n0;
        boolean implies;
        if (!(p instanceof MBeanServerPermission)) {
            return false;
        }
        boolean bl = implies = this.allNames;
        if (!implies && !(implies = (n0 = this.getName()).equals(n1 = p.getName()))) {
            implies = n0.equals("createMBeanServer") && n1.equals("newMBeanServer");
        }
        return implies;
    }

    private void init(String name, String actions) {
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        if (actions != null && actions.length() > 0) {
            throw new IllegalArgumentException("actions must be null or empty");
        }
        if (!(name.equals("*") || name.equals("createMBeanServer") || name.equals("findMBeanServer") || name.equals("newMBeanServer") || name.equals("releaseMBeanServer"))) {
            throw new IllegalArgumentException("Unknown name: " + name);
        }
        this.allNames = name.equals("*");
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.init(this.getName(), this.getActions());
    }

    public PermissionCollection newPermissionCollection() {
        return new MBeanServerPermissionCollections();
    }

    class MBeanServerPermissionCollections
    extends PermissionCollection {
        private static final long serialVersionUID = 3257565088121894454L;
        private HashSet permissions = new HashSet();
        private boolean hasAll;

        MBeanServerPermissionCollections() {
        }

        public void add(Permission p) {
            if (this.isReadOnly()) {
                throw new SecurityException("Collection is read-only");
            }
            if (p instanceof MBeanServerPermission) {
                this.permissions.add(p);
            }
            if (p.getName().equals("createMBeanServer")) {
                this.permissions.add(new MBeanServerPermission("newMBeanServer"));
            } else if (p.getName().equals("*")) {
                this.hasAll = true;
            }
        }

        public boolean implies(Permission p) {
            boolean implies = false;
            if (p instanceof MBeanServerPermission && !(implies = this.hasAll)) {
                implies = this.permissions.contains(p);
            }
            return implies;
        }

        public Enumeration elements() {
            final Iterator iter = this.permissions.iterator();
            Enumeration enumerator = new Enumeration(){

                public boolean hasMoreElements() {
                    return iter.hasNext();
                }

                public Object nextElement() {
                    return iter.next();
                }
            };
            return enumerator;
        }
    }
}

