/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.jboss.aop.Advisor;
import org.jboss.aop.CallerMethodInfo;
import org.jboss.aop.JoinPointInfo;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.IMethodByConInfo;
import org.jboss.aop.joinpoint.Joinpoint;
import org.jboss.aop.joinpoint.MethodCalledByConstructorJoinpoint;

public class MethodByConInfo
extends CallerMethodInfo
implements IMethodByConInfo {
    private final int callingIndex;
    private final Constructor calling;

    public MethodByConInfo(Advisor advisor, Class calledClass, int callingIndex, Method m, long calledMethodHash, Interceptor[] in) {
        super(advisor, calledClass, m, calledMethodHash, in, advisor.getClazz());
        this.callingIndex = callingIndex;
        this.calling = advisor.constructors[callingIndex];
    }

    private MethodByConInfo(MethodByConInfo other) {
        super(other);
        this.callingIndex = other.callingIndex;
        this.calling = other.calling;
    }

    protected Joinpoint internalGetJoinpoint() {
        return new MethodCalledByConstructorJoinpoint(this.calling, this.getMethod());
    }

    public JoinPointInfo copy() {
        return new MethodByConInfo(this);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("Method called by Constructor");
        sb.append("[");
        sb.append("calling=" + this.calling);
        sb.append(",called=" + this.getMethod());
        sb.append("]");
        return sb.toString();
    }

    public int getCallingIndex() {
        return this.callingIndex;
    }

    public Constructor getCalling() {
        return this.calling;
    }
}

