/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.proxy.container;

import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.SerialVersionUID;
import org.jboss.aop.Advised;
import org.jboss.aop.Advisor;
import org.jboss.aop.AspectManager;
import org.jboss.aop.InstanceAdvised;
import org.jboss.aop.MethodInfo;
import org.jboss.aop.instrument.TransformerCommon;
import org.jboss.aop.introduction.InterfaceIntroduction;
import org.jboss.aop.proxy.container.ClassProxyContainer;
import org.jboss.aop.proxy.container.ContainerProxyCacheKey;
import org.jboss.aop.proxy.container.Delegate;
import org.jboss.aop.util.JavassistMethodHashing;

public class ContainerProxyFactory {
    private static final String ADVISED = Advised.class.getName();
    private static final String INSTANCE_ADVISED = InstanceAdvised.class.getName();
    private static final CtClass[] EMPTY_CTCLASS_ARRAY = new CtClass[0];
    public static final String PROXY_NAME_PREFIX = "AOPContainerProxy$";
    private static Object maplock = new Object();
    private static WeakHashMap proxyCache = new WeakHashMap();
    private static volatile int counter = 0;
    private static CtMethod setDelegateMethod;
    private boolean objectAsSuper;
    private Advisor advisor;
    private Class clazz;
    private CtClass proxy;
    private ClassPool pool;
    private ArrayList mixins;
    private boolean isAdvised;
    private CtConstructor defaultCtor;

    public static Class getProxyClass(Class clazz, AspectManager manager) throws Exception {
        ContainerProxyCacheKey key = new ContainerProxyCacheKey(clazz);
        ClassProxyContainer container = ContainerProxyFactory.getTempClassContainer(clazz, manager);
        return ContainerProxyFactory.getProxyClass(false, key, container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class getProxyClass(boolean objectAsSuper, ContainerProxyCacheKey key, Advisor advisor) throws Exception {
        Class clazz = key.getClazz();
        if (Delegate.class.isAssignableFrom(clazz)) {
            clazz = clazz.getSuperclass();
        }
        Class proxyClass = null;
        Object object = maplock;
        synchronized (object) {
            HashMap<ContainerProxyCacheKey, Class> map = (HashMap<ContainerProxyCacheKey, Class>)proxyCache.get(clazz);
            if (map == null) {
                map = new HashMap<ContainerProxyCacheKey, Class>();
                proxyCache.put(clazz, map);
            } else {
                proxyClass = (Class)map.get(key);
            }
            if (proxyClass == null) {
                proxyClass = ContainerProxyFactory.generateProxy(objectAsSuper, clazz, advisor);
                map.put(key, proxyClass);
            }
        }
        return proxyClass;
    }

    private static Class generateProxy(boolean objectAsSuper, Class clazz, Advisor advisor) throws Exception {
        ArrayList introductions = advisor.getInterfaceIntroductions();
        CtClass proxy = ContainerProxyFactory.createProxyCtClass(objectAsSuper, introductions, clazz, advisor);
        ProtectionDomain pd = clazz.getProtectionDomain();
        Class proxyClass = TransformerCommon.toClass(proxy, pd);
        return proxyClass;
    }

    private static ClassProxyContainer getTempClassContainer(Class clazz, AspectManager manager) {
        ClassProxyContainer container = new ClassProxyContainer("temp", manager);
        container.setClass(clazz);
        for (InterfaceIntroduction intro : container.getManager().getInterfaceIntroductions().values()) {
            if (!intro.matches((Advisor)container, container.getClazz())) continue;
            container.addInterfaceIntroduction(intro);
        }
        return container;
    }

    public static CtClass createProxyCtClass(boolean objectAsSuper, ArrayList mixins, Class clazz, Advisor advisor) throws Exception {
        ContainerProxyFactory factory = new ContainerProxyFactory(objectAsSuper, mixins, clazz, advisor);
        return factory.createProxyCtClass();
    }

    private ContainerProxyFactory(boolean objectAsSuper, ArrayList mixins, Class clazz, Advisor advisor) {
        this.objectAsSuper = objectAsSuper;
        this.mixins = mixins;
        this.clazz = clazz;
        this.advisor = advisor;
        this.isAdvised = Advised.class.isAssignableFrom(clazz);
    }

    private CtClass createProxyCtClass() throws Exception {
        this.pool = AspectManager.instance().findClassPool(this.clazz.getClassLoader());
        if (this.pool == null) {
            throw new NullPointerException("Could not find ClassPool");
        }
        this.createBasics();
        this.addMethodsAndMixins();
        this.overrideSpecialMethods(this.clazz, this.proxy);
        SerialVersionUID.setSerialVersionUID((CtClass)this.proxy);
        return this.proxy;
    }

    private CtClass createBasics() throws Exception {
        Class proxySuper = this.objectAsSuper ? Object.class : this.clazz;
        String classname = this.getClassName();
        CtClass template = this.pool.get("org.jboss.aop.proxy.container.ProxyTemplate");
        CtClass superclass = this.pool.get(proxySuper.getName());
        this.proxy = TransformerCommon.makeClass(this.pool, classname, superclass);
        this.proxy.addInterface(this.pool.get("org.jboss.aop.instrument.Untransformable"));
        Class<?>[] interfaces = proxySuper.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            CtClass interfaze = this.pool.get(interfaces[i].getName());
            this.proxy.addInterface(interfaze);
        }
        this.copyConstructors(superclass, this.proxy);
        this.addFieldFromTemplate(template, "mixins");
        this.proxy.addInterface(this.pool.get("org.jboss.aop.proxy.container.Delegate"));
        this.addFieldFromTemplate(template, "delegate", superclass);
        this.addMethodFromTemplate(template, "getDelegate", "{ return delegate; }");
        setDelegateMethod = this.addMethodFromTemplate(template, "setDelegate", "{ this.delegate = (" + proxySuper.getName() + ")$1; }");
        this.proxy.addInterface(this.pool.get("org.jboss.aop.proxy.container.AspectManaged"));
        this.addFieldFromTemplate(template, "currentAdvisor");
        this.addFieldFromTemplate(template, "classAdvisor");
        this.addMethodFromTemplate(template, "getAdvisor", "{return classAdvisor;}");
        this.addMethodFromTemplate(template, "setAdvisor", "{this.classAdvisor = $1;currentAdvisor = classAdvisor;}");
        this.addFieldFromTemplate(template, "metadata");
        this.addMethodFromTemplate(template, "setMetadata", "{this.metadata = $1;}");
        this.addFieldFromTemplate(template, "instanceAdvisor");
        this.addMethodFromTemplate(template, "setInstanceAdvisor", this.instanceAdvisorSetterBody());
        this.addMethodFromTemplate(template, "getInstanceAdvisor", this.instanceAdvisorGetterBody());
        this.addMethodFromTemplate(template, "writeObject", this.writeObjectBody());
        this.addMethodFromTemplate(template, "readObject", this.readObjectBody(superclass));
        if (this.objectAsSuper) {
            this.addMethodFromTemplate(template, "equals", this.equalsBody());
            this.addMethodFromTemplate(template, "hashCode", this.hashCodeBody());
            this.addMethodFromTemplate(template, "toString", this.toStringBody());
        }
        return this.proxy;
    }

    private String instanceAdvisorSetterBody() {
        return "{   synchronized (this)   {   if (this.instanceAdvisor != null)   {      throw new RuntimeException(\"InstanceAdvisor already set\");   }   if (!($1 instanceof org.jboss.aop.proxy.container.InstanceProxyContainer))   {      throw new RuntimeException(\"Wrong type for instance advisor: \" + $1);   }   this.instanceAdvisor = $1;   currentAdvisor = (org.jboss.aop.proxy.container.InstanceProxyContainer)$1;   }}";
    }

    private String instanceAdvisorGetterBody() {
        return "{   synchronized(this)   {      if (instanceAdvisor == null)      {         org.jboss.aop.proxy.container.InstanceProxyContainer ipc = ((org.jboss.aop.proxy.container.ClassProxyContainer)currentAdvisor).createInstanceProxyContainer();         setInstanceAdvisor(ipc);      }   }   return instanceAdvisor;}";
    }

    private String writeObjectBody() {
        return "{   $1.writeObject(delegate);   $1.writeObject(mixins);   $1.writeObject(metadata);   $1.writeObject(classAdvisor.getClazz());}";
    }

    private String readObjectBody(CtClass superclass) {
        return "{   delegate = (" + superclass.getName() + ")$1.readObject();" + "   mixins = (Object[])$1.readObject();" + "   metadata = (org.jboss.aop.metadata.SimpleMetaData)$1.readObject();" + "   java.lang.Class clazz = (java.lang.Class)$1.readObject();" + "   org.jboss.aop.AspectManager manager = org.jboss.aop.AspectManager.getTopLevelAspectManager();" + "   classAdvisor = manager.findAdvisor(clazz);" + "   currentAdvisor = classAdvisor;" + "}";
    }

    private String equalsBody() {
        return "{   if (delegate != null)   {      if ($1 != null && $1 instanceof org.jboss.aop.proxy.container.Delegate)         $1 = ((org.jboss.aop.proxy.container.Delegate) $1).getDelegate();      return delegate.equals($1);   }   else      return super.equals($1);}";
    }

    private String hashCodeBody() {
        return "{   if (delegate != null)      return delegate.hashCode();   else      return super.hashCode();}";
    }

    private String toStringBody() {
        return "{   if (delegate != null)      return delegate.toString();   else      return super.toString();}";
    }

    private CtField addFieldFromTemplate(CtClass template, String name) throws Exception {
        return this.addFieldFromTemplate(template, name, null);
    }

    private CtField addFieldFromTemplate(CtClass template, String name, CtClass type) throws Exception {
        CtField templateField = template.getField(name);
        CtClass fieldType = type == null ? templateField.getType() : type;
        CtField field = new CtField(fieldType, name, this.proxy);
        field.setModifiers(templateField.getModifiers());
        this.proxy.addField(field);
        return field;
    }

    private CtMethod addMethodFromTemplate(CtClass template, String name, String body) throws Exception {
        CtMethod templateMethod = template.getDeclaredMethod(name);
        CtMethod method = CtNewMethod.make((CtClass)templateMethod.getReturnType(), (String)name, (CtClass[])templateMethod.getParameterTypes(), (CtClass[])templateMethod.getExceptionTypes(), (String)body, (CtClass)this.proxy);
        method.setModifiers(templateMethod.getModifiers());
        this.proxy.addMethod(method);
        return method;
    }

    private void copyConstructors(CtClass superclass, CtClass proxy) throws Exception {
        CtConstructor[] ctors = superclass.getConstructors();
        int minParameters = Integer.MAX_VALUE;
        CtConstructor bestCtor = null;
        for (int i = 0; i < ctors.length; ++i) {
            CtClass[] params = ctors[i].getParameterTypes();
            CtConstructor ctor = CtNewConstructor.make((CtClass[])ctors[i].getParameterTypes(), (CtClass[])ctors[i].getExceptionTypes(), (int)2, null, null, (CtClass)proxy);
            ctor.setModifiers(ctors[i].getModifiers());
            proxy.addConstructor(ctor);
            if (params.length < minParameters) {
                bestCtor = ctor;
                minParameters = params.length;
            }
            if (params.length != 0) continue;
            this.defaultCtor = ctor;
        }
        if (minParameters > 0) {
            this.createDefaultConstructor(bestCtor);
        }
    }

    private void createDefaultConstructor(CtConstructor bestCtor) throws NotFoundException, CannotCompileException {
        CtClass[] params = bestCtor.getParameterTypes();
        StringBuffer superCall = new StringBuffer("super(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                superCall.append(", ");
            }
            superCall.append(this.getNullType(params[i]));
        }
        superCall.append(");");
        this.defaultCtor = CtNewConstructor.make((CtClass[])EMPTY_CTCLASS_ARRAY, (CtClass[])EMPTY_CTCLASS_ARRAY, (String)("{" + superCall.toString() + "}"), (CtClass)this.proxy);
        this.proxy.addConstructor(this.defaultCtor);
    }

    private String getNullType(CtClass clazz) {
        if (!clazz.isPrimitive()) {
            return "null";
        }
        if (clazz.equals(CtClass.booleanType)) {
            return "false";
        }
        if (clazz.equals(CtClass.charType)) {
            return "'0'";
        }
        if (clazz.equals(CtClass.byteType)) {
            return "0";
        }
        if (clazz.equals(CtClass.shortType)) {
            return "0";
        }
        if (clazz.equals(CtClass.intType)) {
            return "0";
        }
        if (clazz.equals(CtClass.longType)) {
            return "0L";
        }
        if (clazz.equals(CtClass.floatType)) {
            return "0f";
        }
        if (clazz.equals(CtClass.doubleType)) {
            return "0d";
        }
        return "";
    }

    private void addMethodsAndMixins() throws Exception {
        HashSet addedMethods = new HashSet();
        this.createMixinsAndIntroductions(addedMethods);
        this.createProxyMethods(addedMethods);
    }

    private void createMixinsAndIntroductions(HashSet addedMethods) throws Exception {
        HashSet addedInterfaces = new HashSet();
        Set implementedInterfaces = this.interfacesAsSet();
        if (this.mixins != null) {
            int i;
            HashMap intfs = new HashMap();
            HashMap mixinIntfs = new HashMap();
            ArrayList mixes = new ArrayList();
            for (i = 0; i < this.mixins.size(); ++i) {
                InterfaceIntroduction introduction = (InterfaceIntroduction)this.mixins.get(i);
                this.getIntroductionInterfaces(introduction, intfs, mixinIntfs, mixes, i);
            }
            if (mixes.size() > 0) {
                this.defaultCtor.insertAfter("mixins = new Object[" + mixes.size() + "];");
                for (i = 0; i < mixes.size(); ++i) {
                    InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixes.get(i);
                    String initializer = mixin.getConstruction() == null ? "new " + mixin.getClassName() + "()" : mixin.getConstruction();
                    String code = "mixins[" + i + "] = " + initializer + ";";
                    this.defaultCtor.insertAfter(code);
                    setDelegateMethod.insertAfter("{if (org.jboss.aop.proxy.container.Delegate.class.isAssignableFrom(mixins[" + i + "].getClass())) " + "((org.jboss.aop.proxy.container.Delegate)mixins[" + i + "]).setDelegate($1);}");
                }
            }
            HashMap allMethods = JavassistMethodHashing.getDeclaredMethodMap(this.proxy);
            addedMethods.addAll(allMethods.keySet());
            this.createMixins(addedMethods, mixes, addedInterfaces, implementedInterfaces);
            this.createIntroductions(addedMethods, intfs, addedInterfaces, implementedInterfaces);
        }
    }

    private void getIntroductionInterfaces(InterfaceIntroduction intro, HashMap intfs, HashMap mixins, ArrayList mixes, int idx) {
        for (InterfaceIntroduction.Mixin mixin : intro.getMixins()) {
            mixes.add(mixin);
            for (int i = 0; i < mixin.getInterfaces().length; ++i) {
                if (intfs.containsKey(mixin.getInterfaces()[i])) {
                    intfs.remove(mixin.getInterfaces()[i]);
                }
                if (mixins.containsKey(mixin.getInterfaces()[i])) {
                    throw new RuntimeException("cannot have an IntroductionInterface that introduces several mixins with the same interfaces " + mixin.getInterfaces()[i]);
                }
                mixins.put(mixin.getInterfaces()[i], new Integer(idx));
            }
        }
        if (intro.getInterfaces() != null) {
            for (int i = 0; i < intro.getInterfaces().length; ++i) {
                if (intfs.containsKey(intro.getInterfaces()[i]) || mixins.containsKey(intro.getInterfaces()[i])) continue;
                intfs.put(intro.getInterfaces()[i], new Integer(idx));
            }
        }
    }

    private void createMixins(HashSet addedMethods, ArrayList mixes, HashSet addedInterfaces, Set implementedInterfaces) throws Exception {
        for (int mixinId = 0; mixinId < mixes.size(); ++mixinId) {
            InterfaceIntroduction.Mixin mixin = (InterfaceIntroduction.Mixin)mixes.get(mixinId);
            String[] intfs = mixin.getInterfaces();
            for (int ifId = 0; ifId < intfs.length; ++ifId) {
                String intf = intfs[ifId];
                if (addedInterfaces.contains(intf)) {
                    throw new Exception("2 mixins are implementing the same interfaces " + intf);
                }
                if (implementedInterfaces.contains(intf)) {
                    throw new Exception("Attempting to mixin interface already used by class " + intf);
                }
                CtClass intfClass = this.pool.get(intf);
                CtMethod[] methods = intfClass.getMethods();
                HashSet<Long> mixinMethods = new HashSet<Long>();
                for (int m = 0; m < methods.length; ++m) {
                    Long hash;
                    if (methods[m].getDeclaringClass().getName().equals("java.lang.Object") || mixinMethods.contains(hash = new Long(JavassistMethodHashing.methodHash(methods[m])))) continue;
                    if (addedMethods.contains(hash)) {
                        throw new Exception("More than one mixin has same method");
                    }
                    mixinMethods.add(hash);
                    addedMethods.add(hash);
                    String aopReturnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
                    String returnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ";
                    String args = "null";
                    if (methods[m].getParameterTypes().length > 0) {
                        args = "$args";
                    }
                    String code = "{      try{      " + intf + " mixin = (" + intf + ")mixins[" + mixinId + "];" + "       org.jboss.aop.MethodInfo mi = currentAdvisor.getMethodInfo(" + hash + "L); " + "       org.jboss.aop.advice.Interceptor[] interceptors = mi.getInterceptors();" + "       if (mi != null && interceptors != (Object[])null && interceptors.length > 0) { " + "          org.jboss.aop.proxy.container.ContainerProxyMethodInvocation invocation = new org.jboss.aop.proxy.container.ContainerProxyMethodInvocation(mi, interceptors, this); " + "          invocation.setArguments(" + args + "); " + "          invocation.setTargetObject(mixin); " + "          invocation.setMetaData(metadata);" + "          " + aopReturnStr + " invocation.invokeNext(); " + "       } else { " + "       " + returnStr + " mixin." + methods[m].getName() + "($$);" + "       } " + "    }finally{" + "    }" + "}";
                    CtMethod newMethod = CtNewMethod.make((CtClass)methods[m].getReturnType(), (String)methods[m].getName(), (CtClass[])methods[m].getParameterTypes(), (CtClass[])methods[m].getExceptionTypes(), (String)code, (CtClass)this.proxy);
                    newMethod.setModifiers(1);
                    this.proxy.addMethod(newMethod);
                }
                this.proxy.addInterface(intfClass);
                addedInterfaces.add(intfClass.getName());
            }
        }
    }

    private void createProxyMethods(HashSet addedMethods) throws Exception {
        HashMap allMethods = JavassistMethodHashing.getMethodMap(this.proxy.getSuperclass());
        for (Map.Entry entry : allMethods.entrySet()) {
            Long hash;
            CtMethod m = (CtMethod)entry.getValue();
            if (!Modifier.isPublic((int)m.getModifiers()) || Modifier.isStatic((int)m.getModifiers()) || Modifier.isFinal((int)m.getModifiers()) || addedMethods.contains(hash = (Long)entry.getKey())) continue;
            addedMethods.add(hash);
            String aopReturnStr = m.getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
            String returnStr = m.getReturnType().equals(CtClass.voidType) ? "" : "return ";
            String args = "null";
            String name = null;
            if (this.isAdvised) {
                MethodInfo info = this.advisor.getMethodInfo(hash);
                Method originalMethod = info.getUnadvisedMethod();
                name = originalMethod.getName();
            } else {
                name = m.getName();
            }
            if (m.getParameterTypes().length > 0) {
                args = "$args";
            }
            String code = "{       boolean handled = false;    try{       if (currentAdvisor != null) {          org.jboss.aop.MethodInfo mi = currentAdvisor.getMethodInfo(" + hash + "L); " + "          if (mi == null) " + "             throw new java.lang.NoSuchMethodError(\"" + m.getName() + m.getSignature() + "\");" + "          org.jboss.aop.advice.Interceptor[] interceptors = mi.getInterceptors(); " + "          if (interceptors != (Object[])null && interceptors.length > 0) { " + "             handled = true;" + "             org.jboss.aop.proxy.container.ContainerProxyMethodInvocation invocation = new org.jboss.aop.proxy.container.ContainerProxyMethodInvocation(mi, interceptors, this); " + "             invocation.setArguments(" + args + "); " + "             invocation.setTargetObject(delegate); " + "             invocation.setMetaData(metadata);" + "             " + aopReturnStr + " invocation.invokeNext(); " + "          }" + "       }" + "       if (!handled && delegate != null){ " + "          " + returnStr + " delegate." + name + "($$); " + "       }" + "       return " + this.getNullType(m.getReturnType()) + ";" + "    }finally{" + "    }" + "}";
            CtMethod newMethod = CtNewMethod.make((CtClass)m.getReturnType(), (String)m.getName(), (CtClass[])m.getParameterTypes(), (CtClass[])m.getExceptionTypes(), (String)code, (CtClass)this.proxy);
            newMethod.setModifiers(1);
            this.proxy.addMethod(newMethod);
        }
    }

    private void createIntroductions(HashSet addedMethods, HashMap intfs, HashSet addedInterfaces, Set implementedInterfaces) throws Exception {
        for (String intf : intfs.keySet()) {
            if (addedInterfaces.contains(intf)) {
                throw new Exception("2 mixins are implementing the same interfaces");
            }
            if (implementedInterfaces.contains(intf)) continue;
            CtClass intfClass = this.pool.get(intf);
            CtMethod[] methods = intfClass.getMethods();
            HashSet<Long> mixinMethods = new HashSet<Long>();
            for (int m = 0; m < methods.length; ++m) {
                Long hash;
                if (methods[m].getDeclaringClass().getName().equals("java.lang.Object") || mixinMethods.contains(hash = new Long(JavassistMethodHashing.methodHash(methods[m]))) || addedMethods.contains(hash)) continue;
                mixinMethods.add(hash);
                addedMethods.add(hash);
                String aopReturnStr = methods[m].getReturnType().equals(CtClass.voidType) ? "" : "return ($r)";
                String args = "null";
                if (methods[m].getParameterTypes().length > 0) {
                    args = "$args";
                }
                String code = "{       try{       org.jboss.aop.MethodInfo mi = currentAdvisor.getMethodInfo(" + hash + "L); " + "       if (mi == null) " + "          throw new java.lang.NoSuchMethodError(\"" + methods[m].getName() + methods[m].getSignature() + "\");" + "       org.jboss.aop.advice.Interceptor[] interceptors = mi.getInterceptors();" + "       org.jboss.aop.proxy.container.ContainerProxyMethodInvocation invocation = new org.jboss.aop.proxy.container.ContainerProxyMethodInvocation(mi, interceptors, this); " + "       invocation.setArguments(" + args + "); " + "       invocation.setTargetObject(delegate); " + "       invocation.setMetaData(metadata);" + "       " + aopReturnStr + " invocation.invokeNext(); " + "    }finally{" + "    }" + "}";
                CtMethod newMethod = CtNewMethod.make((CtClass)methods[m].getReturnType(), (String)methods[m].getName(), (CtClass[])methods[m].getParameterTypes(), (CtClass[])methods[m].getExceptionTypes(), (String)code, (CtClass)this.proxy);
                newMethod.setModifiers(1);
                this.proxy.addMethod(newMethod);
            }
            this.proxy.addInterface(intfClass);
            addedInterfaces.add(intfClass.getName());
        }
    }

    private Set interfacesAsSet() throws NotFoundException {
        HashSet<String> set = new HashSet<String>();
        CtClass[] interfaces = this.proxy.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            set.add(interfaces[i].getName());
        }
        return set;
    }

    private String getClassName() {
        String packageName = this.clazz.getPackage().getName();
        packageName = packageName.indexOf("java.") != -1 && packageName.indexOf("sun.") != -1 ? packageName + "." : "";
        return packageName + PROXY_NAME_PREFIX + counter++;
    }

    private void overrideSpecialMethods(Class clazz, CtClass proxy) throws Exception {
        this.addInstanceAdvisedMethods(clazz, proxy);
    }

    private void addInstanceAdvisedMethods(Class clazz, CtClass proxy) throws Exception {
        CtClass advisedInterface = null;
        CtClass[] interfaces = proxy.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!interfaces[i].getName().equals(ADVISED)) continue;
            advisedInterface = interfaces[i];
            break;
        }
        if (advisedInterface != null) {
            CtMethod[] methods = advisedInterface.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getDeclaringClass().getName().equals(INSTANCE_ADVISED)) continue;
                String name = methods[i].getName();
                String body = null;
                if (name.equals("_getInstanceAdvisor")) {
                    body = "{ return getInstanceAdvisor(); }";
                } else if (name.equals("_setInstanceAdvisor")) {
                    body = "{ setInstanceAdvisor($1); }";
                }
                if (body == null) continue;
                CtMethod m = CtNewMethod.make((CtClass)methods[i].getReturnType(), (String)methods[i].getName(), (CtClass[])methods[i].getParameterTypes(), (CtClass[])methods[i].getExceptionTypes(), (String)body, (CtClass)proxy);
                m.setModifiers(1);
                proxy.addMethod(m);
            }
        }
    }
}

