/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.versioned;

import org.jboss.aop.Advised;
import org.jboss.aop.proxy.ClassProxy;
import org.jboss.aop.proxy.ClassProxyFactory;
import org.jboss.aop.util.PayloadKey;
import org.jboss.aspects.versioned.DistributedVersionManager;
import org.jboss.aspects.versioned.LocalSynchronizationManager;
import org.jboss.aspects.versioned.VersionedObject;
import org.jboss.aspects.versioned.VersionedObjectForwardingInterceptor;
import org.jboss.aspects.versioned.VersionedObjectInterceptorFactory;

public class Versioned {
    public static final String VERSIONED = "VERSIONED";
    public static final String VERSIONED_OBJECT = "VERSIONED_OBJECT";
    public static final String READONLY = "read-only";
    static DistributedVersionManager localManager = null;

    public static Object makeVersioned(Object target) throws Exception {
        if (target instanceof ClassProxy) {
            throw new IllegalStateException("A ClassProxy is not allowed to be Versioned.  You must have a concrete object");
        }
        ClassProxy proxy = ClassProxyFactory.newInstance(target.getClass());
        VersionedObject versioned = new VersionedObject(target);
        proxy._getInstanceAdvisor().getMetaData().addMetaData(VERSIONED, VERSIONED_OBJECT, versioned, PayloadKey.TRANSIENT);
        proxy._getInstanceAdvisor().appendInterceptor(VersionedObjectInterceptorFactory.getInstance());
        proxy._getInstanceAdvisor().appendInterceptor(new VersionedObjectForwardingInterceptor());
        return proxy;
    }

    public static synchronized DistributedVersionManager getLocalVersionManager() throws Exception {
        if (localManager == null) {
            LocalSynchronizationManager synchManager = new LocalSynchronizationManager(null);
            synchManager.versionManager = localManager = new DistributedVersionManager(1000L, synchManager);
        }
        return localManager;
    }

    public static void makePerFieldVersioned(Object target) throws Exception {
        if (!(target instanceof Advised)) {
            throw new IllegalArgumentException("Cannot do per field versioning with a non-Advised object");
        }
        Advised advised = (Advised)target;
        Versioned.getLocalVersionManager().makeVersioned(advised);
    }
}

