/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beans.metadata.plugins;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Iterator;
import org.jboss.annotation.factory.AnnotationCreator;
import org.jboss.annotation.factory.ast.TokenMgrError;
import org.jboss.beans.metadata.spi.AnnotationMetaData;
import org.jboss.beans.metadata.spi.MetaDataVisitor;
import org.jboss.beans.metadata.spi.MetaDataVisitorNode;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;
import org.jboss.util.StringPropertyReplacer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractAnnotationMetaData
extends JBossObject
implements AnnotationMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    public String annotation;
    protected Annotation ann;
    protected boolean replace = true;

    public String getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(String annotation) {
        this.annotation = annotation;
    }

    public boolean isReplace() {
        return this.replace;
    }

    public void setReplace(boolean replace) {
        this.replace = replace;
    }

    @Override
    public Annotation getAnnotationInstance() {
        try {
            String annString = this.annotation;
            if (this.replace) {
                annString = StringPropertyReplacer.replaceProperties(annString);
            }
            this.ann = (Annotation)AnnotationCreator.createAnnotation(annString, Thread.currentThread().getContextClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating annotation for " + this.annotation, e);
        }
        catch (TokenMgrError e) {
            throw new RuntimeException("Error creating annotation for " + this.annotation, e);
        }
        return this.ann;
    }

    @Override
    public void initialVisit(MetaDataVisitor visitor) {
        visitor.initialVisit(this);
    }

    @Override
    public void describeVisit(MetaDataVisitor vistor) {
        vistor.describeVisit(this);
    }

    @Override
    public Iterator<? extends MetaDataVisitorNode> getChildren() {
        return null;
    }

    @Override
    public void toString(JBossStringBuilder buffer) {
        buffer.append("expr=").append(this.ann);
    }

    @Override
    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.ann);
    }

    @Override
    protected int getHashCode() {
        return this.annotation.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractAnnotationMetaData)) {
            return false;
        }
        AbstractAnnotationMetaData amd = (AbstractAnnotationMetaData)object;
        return this.replace == amd.replace && this.annotation.equals(amd.annotation);
    }
}

