/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.advice;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.aop.microcontainer.aspects.util.ProxyUtils;
import org.jboss.deployers.spi.attachments.Attachments;
import org.jboss.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrackingAdvice {
    private static Logger log = Logger.getLogger(TrackingAdvice.class);
    private static ConcurrentHashMap<Object, Map<String, Object>> attachmentsByTarget = new ConcurrentHashMap();

    public static Attachments wrapAttachments(Attachments attachments) {
        return ProxyUtils.createProxy(attachments, Attachments.class);
    }

    public static Object invoke(Invocation inv) throws Throwable {
        return inv.invokeNext();
    }

    public static Object addAttachment(MethodInvocation mi) throws Throwable {
        Object attachment;
        String name;
        Object target = mi.getTargetObject();
        Object[] args = mi.getArguments();
        Object value = mi.invokeNext();
        if (args == null || args.length < 2) {
            throw new IllegalArgumentException("Illegal method invocation, possibly not adding attachment?");
        }
        if (args[0] instanceof Class) {
            Class c = (Class)Class.class.cast(args[0]);
            name = c.getName();
            attachment = args[1];
        } else {
            name = (String)String.class.cast(args[0]);
            attachment = args[1];
        }
        TrackingAdvice.addAttachment(target, name, attachment);
        return value;
    }

    public static Object removeAttachment(MethodInvocation mi) throws Throwable {
        String name;
        Object target = mi.getTargetObject();
        Object[] args = mi.getArguments();
        Object value = mi.invokeNext();
        if (args == null || args.length < 1) {
            throw new IllegalArgumentException("Illegal method invocation, possibly not removing attachment?");
        }
        if (args[0] instanceof Class) {
            Class c = (Class)Class.class.cast(args[0]);
            name = c.getName();
        } else {
            name = (String)String.class.cast(args[0]);
        }
        TrackingAdvice.removeAttachment(target, name);
        return value;
    }

    public static Map<String, Object> getAttachmentsForTarget(Object key) {
        return attachmentsByTarget.get(key);
    }

    public static Map<String, Object> clearAttachmentsForTarget(Object key) {
        return attachmentsByTarget.remove(key);
    }

    private static void addAttachment(Object target, String name, Object attachment) {
        Map<String, Object> attachments = attachmentsByTarget.get(target);
        if (attachments == null) {
            attachments = new HashMap<String, Object>();
            attachmentsByTarget.put(target, attachments);
        }
        attachments.put(name, attachment);
    }

    private static void removeAttachment(Object target, String name) {
        Map<String, Object> attachments = attachmentsByTarget.get(target);
        if (attachments != null) {
            attachments.remove(name);
            if (attachments.size() == 0) {
                attachmentsByTarget.remove(target);
            }
        }
    }
}

