/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.attachments;

import java.io.Serializable;
import org.jboss.deployers.spi.attachments.Attachments;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAttachments
implements Attachments,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public <T> T addAttachment(String name, T attachment, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.addAttachment(name, attachment);
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    @Override
    public <T> T addAttachment(Class<T> type, T attachment) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.addAttachment(type.getName(), attachment, type);
    }

    @Override
    public <T> T getAttachment(String name, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.getAttachment(name);
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    @Override
    public <T> T getAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.getAttachment(type.getName(), type);
    }

    @Override
    public boolean isAttachmentPresent(String name, Class<?> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.getAttachment(name);
        if (result == null) {
            return false;
        }
        try {
            expectedType.cast(result);
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isAttachmentPresent(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.isAttachmentPresent(type.getName(), type);
    }

    @Override
    public <T> T removeAttachment(String name, Class<T> expectedType) {
        if (expectedType == null) {
            throw new IllegalArgumentException("Null expectedType");
        }
        Object result = this.removeAttachment(name);
        if (result == null) {
            return null;
        }
        return expectedType.cast(result);
    }

    @Override
    public <T> T removeAttachment(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("Null type");
        }
        return this.removeAttachment(type.getName(), type);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("You cannot clear attachments here.");
    }
}

