/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers.helpers;

import java.util.List;
import org.jboss.deployers.plugins.deployers.helpers.AbstractTypedDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractParsingDeployer<T>
extends AbstractTypedDeployer<T> {
    protected AbstractParsingDeployer(Class<T> deploymentType) {
        super(deploymentType);
        this.setRelativeOrder(2000);
    }

    protected boolean allowsReparse() {
        return false;
    }

    protected T getMetaData(DeploymentUnit unit, String key) {
        return unit.getAttachment(key, this.getDeploymentType());
    }

    protected void createMetaData(DeploymentUnit unit, String name, String suffix) throws DeploymentException {
        this.createMetaData(unit, name, suffix, this.getDeploymentType().getName());
    }

    protected void createMetaData(DeploymentUnit unit, String name, String suffix, String key) throws DeploymentException {
        T result = this.getMetaData(unit, key);
        if (result != null && !this.allowsReparse()) {
            return;
        }
        try {
            result = suffix == null ? this.parse(unit, name, result) : this.parse(unit, name, suffix, result);
            if (result != null) {
                unit.getTypes().add(this.getType());
            }
        }
        catch (Exception e) {
            throw DeploymentException.rethrowAsDeploymentException("Error creating managed object for " + unit.getName(), e);
        }
        if (result == null) {
            return;
        }
        unit.addAttachment(key, result, this.getDeploymentType());
    }

    protected T parse(DeploymentUnit unit, String name, T root) throws Exception {
        VirtualFile file = unit.getMetaDataFile(name);
        if (file == null) {
            return null;
        }
        T result = this.parse(unit, file, root);
        this.init(unit, result, file);
        return result;
    }

    protected T parse(DeploymentUnit unit, String name, String suffix, T root) throws Exception {
        List<VirtualFile> files = unit.getMetaDataFiles(name, suffix);
        if (files.size() == 0) {
            return null;
        }
        if (files.size() > 1) {
            throw new DeploymentException("Only one file is allowed, found=" + files);
        }
        VirtualFile file = files.get(0);
        T result = this.parse(unit, file, root);
        this.init(unit, result, file);
        return result;
    }

    protected abstract T parse(DeploymentUnit var1, VirtualFile var2, T var3) throws Exception;

    protected void init(DeploymentUnit unit, T metaData, VirtualFile file) throws Exception {
    }
}

