/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.deployers.helpers;

import java.io.InputStream;
import org.jboss.deployers.plugins.deployers.helpers.AbstractParsingDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.Unmarshaller;
import org.jboss.xb.binding.UnmarshallerFactory;
import org.jboss.xb.binding.sunday.unmarshalling.SchemaBindingResolver;
import org.jboss.xb.binding.sunday.unmarshalling.SingletonSchemaResolverFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaResolverDeployer<T>
extends AbstractParsingDeployer<T> {
    private static final UnmarshallerFactory factory = UnmarshallerFactory.newInstance();
    private static final SchemaBindingResolver resolver = SingletonSchemaResolverFactory.getInstance().getSchemaBindingResolver();

    public SchemaResolverDeployer(Class<T> deploymentType) {
        super(deploymentType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected T parse(DeploymentUnit unit, VirtualFile file, T root) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Null file");
        }
        this.log.debug("Parsing file: " + file + " for deploymentType: " + this.getDeploymentType());
        Unmarshaller unmarshaller = factory.newUnmarshaller();
        InputStream is = file.openStream();
        Object parsed = null;
        try {
            parsed = unmarshaller.unmarshal(is, resolver);
            this.log.debug("Parsed file: " + file + " to: " + parsed);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception ignored) {}
        }
        if (parsed == null) {
            throw new DeploymentException("The xml " + file.getPathName() + " is not well formed!");
        }
        return this.getDeploymentType().cast(parsed);
    }
}

