/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.deployers.spi.structure.vfs.ContextInfo;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructureMetaDataImpl
implements StructureMetaData,
Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, ContextInfo> contextMap = new HashMap();
    private TreeSet<ContextInfo> contextSet = new TreeSet<ContextInfo>(new ContextComparator());

    @Override
    public void addContext(ContextInfo context) {
        String key = context.getVfsPath();
        this.contextMap.put(key, context);
        ContextInfo parent = context.getParent();
        if (parent == null) {
            String[] keys = key.split("/");
            StringBuilder parentKey = new StringBuilder();
            for (int n = 0; n < keys.length - 1; ++n) {
                key = keys[n];
                parentKey.append(key);
                parent = this.contextMap.get(parentKey.toString());
                if (parent != null) {
                    context.setParent(parent);
                }
                parentKey.append('/');
            }
            if (keys.length == 1 && (parent = this.contextMap.get("")) != null) {
                context.setParent(parent);
            }
        }
        if (!this.contextSet.add(context)) {
            throw new IllegalStateException("Failed to add: " + context);
        }
    }

    @Override
    public ContextInfo getContext(String vfsPath) {
        return this.contextMap.get(vfsPath);
    }

    @Override
    public ContextInfo removeContext(String vfsPath) {
        ContextInfo info = this.contextMap.remove(vfsPath);
        if (info != null) {
            this.contextSet.remove(info);
        }
        return info;
    }

    @Override
    public SortedSet<ContextInfo> getContexts() {
        return this.contextSet;
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder(super.toString());
        tmp.append("[ContextInfo:");
        tmp.append(this.contextSet.toString());
        tmp.append(']');
        return tmp.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ContextComparator
    implements Comparator<ContextInfo> {
        @Override
        public int compare(ContextInfo o1, ContextInfo o2) {
            int compare = 0;
            if (o1 == null && o2 != null) {
                compare = -1;
            } else if (o1 != null && o2 == null) {
                compare = 1;
            } else {
                String[] p2;
                String[] p1 = o1.getVfsPath().split("/");
                compare = p1.length - (p2 = o2.getVfsPath().split("/")).length;
                if (compare == 0) {
                    String p2p;
                    String p1p;
                    for (int n = 0; n < p1.length && (compare = (p1p = p1[n]).compareTo(p2p = p2[n])) == 0; ++n) {
                    }
                }
            }
            return compare;
        }
    }
}

