/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.plugins.structure.vfs.jar;

import java.io.IOException;
import java.util.Set;
import org.jboss.deployers.plugins.structure.ContextInfoImpl;
import org.jboss.deployers.plugins.structure.vfs.AbstractStructureDeployer;
import org.jboss.deployers.plugins.structure.vfs.jar.SecurityActions;
import org.jboss.deployers.spi.structure.vfs.StructureMetaData;
import org.jboss.deployers.spi.structure.vfs.StructuredDeployers;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.plugins.context.jar.JarUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JARStructure
extends AbstractStructureDeployer {
    public JARStructure() {
        this(null);
    }

    public JARStructure(Set<String> suffixes) {
        if (suffixes != null) {
            JarUtils.setJarSuffixes(suffixes);
        }
        this.setRelativeOrder(10000);
    }

    public Set<String> getSuffixes() {
        return JarUtils.getSuffixes();
    }

    public void setSuffixes(Set<String> suffixes) {
        JarUtils.setJarSuffixes(suffixes);
    }

    @Override
    public boolean determineStructure(VirtualFile root, StructureMetaData metaData, StructuredDeployers deployers) {
        String contextPath = null;
        try {
            if (!SecurityActions.isLeaf(root)) {
                if (!JarUtils.isArchive(root.getName())) {
                    if (!this.isTopLevel(root, metaData)) {
                        try {
                            root.findChild("META-INF");
                            this.log.trace("... ok - non top level directory has a META-INF subdirectory");
                        }
                        catch (IOException e) {
                            this.log.trace("... no - doesn't look like a jar and no META-INF subdirectory.");
                            return false;
                        }
                    } else {
                        this.log.trace("... ok - doesn't look like a jar but it is a top level directory.");
                    }
                }
            } else if (JarUtils.isArchive(root.getName())) {
                this.log.trace("... ok - its an archive or at least pretending to be.");
            } else {
                this.log.trace("... no - not a directory or an archive.");
                return false;
            }
            ContextInfoImpl context = new ContextInfoImpl(root.getPathName());
            context.setMetaDataPath("META-INF");
            super.addClassPath(root, root, true, true, context);
            metaData.addContext(context);
            contextPath = context.getVfsPath();
            this.addAllChildren(root, metaData, deployers);
            return true;
        }
        catch (Exception e) {
            this.log.warn("Error determining structure: " + root.getName(), e);
            if (contextPath != null) {
                metaData.removeContext(contextPath);
            }
            return false;
        }
    }
}

