/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.spi;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.dependency.spi.DependencyInfo;
import org.jboss.dependency.spi.DependencyItem;
import org.jboss.deployers.spi.IncompleteDeployments;
import org.jboss.deployers.spi.MissingDependency;
import org.jboss.deployers.spi.deployment.MainDeployer;
import org.jboss.deployers.spi.structure.DeploymentContext;

public class IncompleteDeploymentsBuilder {
    private static Throwable getCause(Throwable original) {
        if (original == null) {
            return null;
        }
        Throwable result = original;
        for (Throwable cause = result.getCause(); cause != null; cause = cause.getCause()) {
            result = cause;
        }
        return result;
    }

    public static IncompleteDeployments build(MainDeployer main, Controller controller) {
        HashMap<String, Throwable> deploymentsInError = null;
        HashSet<String> deploymentsMissingDeployer = null;
        HashMap<String, Throwable> contextsInError = null;
        HashMap contextsMissingDependencies = null;
        if (main != null) {
            Collection<DeploymentContext> missingDeployer;
            Collection<DeploymentContext> errors = main.getErrors();
            if (errors != null && !errors.isEmpty()) {
                deploymentsInError = new HashMap<String, Throwable>();
                for (DeploymentContext context : errors) {
                    deploymentsInError.put(context.getName(), IncompleteDeploymentsBuilder.getCause(context.getProblem()));
                }
            }
            if ((missingDeployer = main.getMissingDeployer()) != null && !missingDeployer.isEmpty()) {
                deploymentsMissingDeployer = new HashSet<String>();
                for (DeploymentContext deploymentContext : missingDeployer) {
                    deploymentsMissingDeployer.add(deploymentContext.getName());
                }
            }
        }
        if (controller != null) {
            List<ControllerState> states = controller.getStates();
            Set<ControllerContext> notInstalled = controller.getNotInstalled();
            if (!notInstalled.isEmpty()) {
                Iterator<ControllerContext> i = notInstalled.iterator();
                while (i.hasNext()) {
                    ControllerContext controllerContext = i.next();
                    if (!controllerContext.getState().equals(controllerContext.getRequiredState())) continue;
                    i.remove();
                }
                if (!notInstalled.isEmpty()) {
                    contextsInError = new HashMap<String, Throwable>();
                    contextsMissingDependencies = new HashMap();
                    for (ControllerContext controllerContext : notInstalled) {
                        if (controllerContext.getState().equals(ControllerState.ERROR)) {
                            contextsInError.put(controllerContext.getName().toString(), IncompleteDeploymentsBuilder.getCause(controllerContext.getError()));
                            continue;
                        }
                        String name = controllerContext.getName().toString();
                        HashSet<MissingDependency> dependencies = new HashSet<MissingDependency>();
                        DependencyInfo dependsInfo = controllerContext.getDependencyInfo();
                        for (DependencyItem item : dependsInfo.getIDependOn(null)) {
                            int actual;
                            String actualStateString;
                            String dependency;
                            if (item.isResolved()) continue;
                            ControllerState actualState = null;
                            Object iDependOn = item.getIDependOn();
                            if (iDependOn == null) {
                                dependency = "<UNKNOWN>";
                                actualStateString = "** UNRESOLVED " + item + " **";
                            } else {
                                dependency = iDependOn.toString();
                                ControllerContext other = controller.getContext(item.getIDependOn(), null);
                                if (other == null) {
                                    actualStateString = "** NOT FOUND **";
                                } else {
                                    actualState = other.getState();
                                    actualStateString = actualState.getStateString();
                                }
                            }
                            ControllerState requiredState = item.getWhenRequired();
                            String requiredStateString = requiredState.getStateString();
                            int required = states.indexOf(requiredState);
                            if (required <= (actual = actualState == null ? -1 : states.indexOf(actualState))) continue;
                            MissingDependency missing = new MissingDependency(name, dependency, requiredStateString, actualStateString);
                            dependencies.add(missing);
                        }
                        contextsMissingDependencies.put(name, dependencies);
                    }
                }
            }
        }
        return new IncompleteDeployments(deploymentsInError, deploymentsMissingDeployer, contextsInError, contextsMissingDependencies);
    }
}

