/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.io.File;
import java.io.FileFilter;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.jboss.deployment.DeploymentInfo;
import org.jboss.deployment.JARDeployerMBean;
import org.jboss.deployment.SubDeployerSupport;
import org.jboss.util.Strings;

public class JARDeployer
extends SubDeployerSupport
implements JARDeployerMBean {
    private static final String[] DEFAULT_ENHANCED_SUFFIXES = new String[]{"700:.jar", "750:.zip", "900:.last"};
    private String[] descriptorNames = new String[]{".xml"};

    public JARDeployer() {
        super.setEnhancedSuffixes(DEFAULT_ENHANCED_SUFFIXES);
    }

    public String[] getDescriptorNames() {
        return this.descriptorNames;
    }

    public void setDescriptorNames(String[] descriptorNames) {
        this.descriptorNames = descriptorNames;
    }

    protected void stopService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean accepts(DeploymentInfo di) {
        boolean trace = this.log.isTraceEnabled();
        try {
            URL ddDir;
            if (di.shortName.indexOf(46) != -1 && !super.accepts(di)) {
                return false;
            }
            URL wdDir = di.localCl.findResource("WEB-INF/");
            if (wdDir != null) {
                return false;
            }
            try {
                ddDir = di.localCl.findResource("META-INF/");
                if (ddDir == null) {
                    this.log.debug("No META-INF or WEB-INF resource found, assuming it if for us");
                    return true;
                }
            }
            catch (ClassCastException e) {
                ddDir = new URL(di.url, "META-INF/");
            }
            if (ddDir.getProtocol().equals("file")) {
                this.log.trace("File protocol: " + ddDir);
                File file = new File(ddDir.getFile());
                if (!file.exists()) {
                    this.log.warn("File not found: " + file);
                    return true;
                }
                File[] entries = file.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        boolean accept = false;
                        String name = pathname.getName();
                        for (int n = 0; !accept && n < JARDeployer.this.descriptorNames.length; ++n) {
                            String d = JARDeployer.this.descriptorNames[n];
                            accept = name.endsWith(d);
                        }
                        return accept;
                    }
                });
                this.log.debug("XML entries found: " + entries.length);
                if (entries.length != 0) return false;
                return true;
            }
            if (!ddDir.getProtocol().equals("jar")) {
                this.log.debug("Unrecognized protocol: " + ddDir.getProtocol());
                return false;
            }
            this.log.trace("jar protocol: " + ddDir);
            ZipFile jarFile = null;
            try {
                URLConnection con = ddDir.openConnection();
                JarURLConnection jarConn = (JarURLConnection)con;
                jarConn.setUseCaches(false);
                jarFile = jarConn.getJarFile();
                if (trace) {
                    this.log.trace("Descriptor names=" + Arrays.asList(this.descriptorNames));
                }
                Enumeration<JarEntry> e = ((JarFile)jarFile).entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String name = entry.getName();
                    if (trace) {
                        this.log.trace("Looking at entry: '" + name + "'");
                    }
                    if (!name.startsWith("META-INF/") || Strings.count(name, "/") != 1) continue;
                    for (int n = 0; n < this.descriptorNames.length; ++n) {
                        if (!name.endsWith(this.descriptorNames[n])) continue;
                        this.log.debug("Found entry: '" + name + "', matching: '" + this.descriptorNames[n] + "', rejecting jar");
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            catch (Exception e) {
                this.log.warn("Looking inside jar failed; ignoring", e);
                boolean bl = false;
                return bl;
            }
            finally {
                if (jarFile != null) {
                    jarFile.close();
                }
                jarFile = null;
            }
            this.log.debug("No xml files found");
            return true;
        }
        catch (Exception e) {
            this.log.trace("Ignored error", e);
            return false;
        }
    }
}

