/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.management.ObjectName;
import org.jboss.deployers.plugins.deployer.AbstractSimpleDeployer;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentUnit;
import org.jboss.deployment.security.JaccPolicy;
import org.jboss.system.metadata.ServiceConstructorMetaData;
import org.jboss.system.metadata.ServiceDeployment;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityDeployer
extends AbstractSimpleDeployer {
    private HashSet<String> ignoreSuffixes = null;

    public SecurityDeployer() {
        this.setRelativeOrder(6999);
    }

    public void setIgnoreSuffixes(HashSet<String> suffixSet) {
        this.ignoreSuffixes = suffixSet;
    }

    @Override
    public void deploy(DeploymentUnit unit) throws DeploymentException {
        if (unit.getParent() != null) {
            return;
        }
        String contextId = unit.getSimpleName();
        for (String suffix : this.ignoreSuffixes) {
            String dotSuffix = "." + suffix;
            if (!contextId.endsWith(dotSuffix)) continue;
            this.log.debug("Ignoring: " + contextId);
            return;
        }
        ServiceMetaData jaccPolicy = new ServiceMetaData();
        jaccPolicy.setCode(JaccPolicy.class.getName());
        try {
            jaccPolicy.setObjectName(new ObjectName(JaccPolicy.BASE_OBJECT_NAME + contextId));
        }
        catch (Exception e) {
            // empty catch block
        }
        ServiceConstructorMetaData constructor = new ServiceConstructorMetaData();
        constructor.setSignature(new String[]{String.class.getName(), DeploymentUnit.class.getName(), Collection.class.getName()});
        constructor.setParameters(new Object[]{contextId, unit, this.ignoreSuffixes});
        jaccPolicy.setConstructor(constructor);
        ArrayList<ServiceMetaData> services = new ArrayList<ServiceMetaData>();
        services.add(jaccPolicy);
        ServiceDeployment sd = new ServiceDeployment();
        sd.setServices(services);
        unit.addAttachment("jboss.jaccpolicy", sd, ServiceDeployment.class);
    }

    @Override
    public void undeploy(DeploymentUnit unit) {
        unit.removeAttachment("jboss.jaccpolicy", ServiceDeployment.class);
    }
}

