/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import javax.ejb.RemoveException;
import javax.ejb.TimedObject;
import javax.ejb.Timer;
import javax.management.ObjectName;
import org.jboss.ejb.Container;
import org.jboss.ejb.EJBProxyFactory;
import org.jboss.ejb.InstancePool;
import org.jboss.ejb.Interceptor;
import org.jboss.ejb.LocalProxyFactory;
import org.jboss.ejb.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.MarshalledInvocation;
import org.jboss.metadata.SessionMetaData;
import org.jboss.proxy.ejb.ClusterProxyFactory;

public abstract class SessionContainer
extends Container {
    protected Map homeMapping;
    protected Map beanMapping;
    protected Interceptor interceptor;
    protected Class serviceEndpoint;
    protected InstancePool instancePool;

    public void setInstancePool(InstancePool ip) {
        if (ip == null) {
            throw new IllegalArgumentException("Null pool");
        }
        this.instancePool = ip;
        ip.setContainer(this);
    }

    public InstancePool getInstancePool() {
        return this.instancePool;
    }

    public LocalProxyFactory getLocalProxyFactory() {
        return this.localProxyFactory;
    }

    public void addInterceptor(Interceptor in) {
        if (this.interceptor == null) {
            this.interceptor = in;
        } else {
            Interceptor current = this.interceptor;
            while (current.getNext() != null) {
                current = current.getNext();
            }
            current.setNext(in);
        }
    }

    public Interceptor getInterceptor() {
        return this.interceptor;
    }

    public Class getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            if (this.metaData.getHome() != null) {
                this.homeInterface = this.classLoader.loadClass(this.metaData.getHome());
            }
            if (this.metaData.getRemote() != null) {
                this.remoteInterface = this.classLoader.loadClass(this.metaData.getRemote());
            }
            if (((SessionMetaData)this.metaData).getServiceEndpoint() != null) {
                this.serviceEndpoint = this.classLoader.loadClass(((SessionMetaData)this.metaData).getServiceEndpoint());
            }
            super.createService();
            this.checkCoherency();
            this.setupBeanMapping();
            this.setupHomeMapping();
            this.setupMarshalledInvocationMapping();
            this.createInvokers();
            this.createInstanceCache();
            this.createInstancePool();
            this.createPersistenceManager();
            this.createInterceptors();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    protected abstract void setupHomeMapping() throws Exception;

    protected void setUpBeanMappingImpl(Map map, Method[] methods, String declaringClass) throws NoSuchMethodException {
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getDeclaringClass().getName().equals(declaringClass)) {
                try {
                    Method beanMethod = this.beanClass.getMethod(m.getName(), m.getParameterTypes());
                    map.put(m, beanMethod);
                }
                catch (NoSuchMethodException ex) {
                    throw new NoSuchMethodException("Not found in bean class: " + m);
                }
                this.log.debug("Mapped " + m.getName() + " HASH " + m.hashCode() + "to " + map.get(m));
                continue;
            }
            try {
                Method containerMethod = this.getClass().getMethod(m.getName(), Invocation.class);
                map.put(m, containerMethod);
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodException("Not found in container class: " + m);
            }
            this.log.debug("Mapped Container method " + m.getName() + " HASH " + m.hashCode());
        }
    }

    protected void setupBeanMapping() throws NoSuchMethodException {
        Method[] m;
        HashMap map = new HashMap();
        if (this.remoteInterface != null) {
            m = this.remoteInterface.getMethods();
            this.setUpBeanMappingImpl(map, m, "javax.ejb.EJBObject");
        }
        if (this.localInterface != null) {
            m = this.localInterface.getMethods();
            this.setUpBeanMappingImpl(map, m, "javax.ejb.EJBLocalObject");
        }
        if (TimedObject.class.isAssignableFrom(this.beanClass)) {
            m = new Method[]{TimedObject.class.getMethod("ejbTimeout", Timer.class)};
            this.setUpBeanMappingImpl(map, m, "javax.ejb.Timer");
        }
        if (this.serviceEndpoint != null) {
            m = this.serviceEndpoint.getMethods();
            this.setUpBeanMappingImpl(map, m, "java.rmi.Remote");
        }
        this.beanMapping = map;
    }

    protected void setupMarshalledInvocationMapping() throws Exception {
        Method[] m;
        if (this.homeInterface != null) {
            m = this.homeInterface.getMethods();
            for (int i = 0; i < m.length; ++i) {
                this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(m[i])), m[i]);
            }
        }
        if (this.remoteInterface != null) {
            m = this.remoteInterface.getMethods();
            for (int j = 0; j < m.length; ++j) {
                this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(m[j])), m[j]);
            }
        }
        Method getEJBObjectMethod = Class.forName("javax.ejb.Handle").getMethod("getEJBObject", new Class[0]);
        this.marshalledInvocationMapping.put(new Long(MarshalledInvocation.calculateHash(getEJBObjectMethod)), getEJBObjectMethod);
    }

    protected void checkCoherency() throws Exception {
        if (this.metaData.isClustered()) {
            boolean clusteredProxyFactoryFound = false;
            for (String invokerBinding : this.proxyFactories.keySet()) {
                EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
                if (!(ci instanceof ClusterProxyFactory)) continue;
                clusteredProxyFactoryFound = true;
            }
            if (!clusteredProxyFactoryFound) {
                this.log.warn("*** EJB '" + this.metaData.getEjbName() + "' deployed as CLUSTERED but not a single clustered-invoker is bound to container ***");
            }
        }
    }

    protected void createInstancePool() throws Exception {
        try {
            ObjectName containerName = super.getJmxName();
            Hashtable props = containerName.getKeyPropertyList();
            props.put("plugin", "pool");
            ObjectName poolName = new ObjectName(containerName.getDomain(), props);
            this.server.registerMBean(this.instancePool, poolName);
        }
        catch (Throwable t) {
            this.log.debug("Failed to register pool as mbean", t);
        }
        this.instancePool.create();
    }

    protected void createInstanceCache() throws Exception {
    }

    protected void createInvokers() throws Exception {
        for (String invokerBinding : this.proxyFactories.keySet()) {
            EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
            ci.create();
        }
    }

    protected void createInterceptors() throws Exception {
        for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
            in.setContainer(this);
            in.create();
        }
    }

    protected void createPersistenceManager() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            super.startService();
            this.startInvokers();
            this.startInstanceCache();
            this.startInstancePool();
            this.startPersistenceManager();
            this.startInterceptors();
            this.restoreTimers();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    protected void startPersistenceManager() throws Exception {
    }

    protected void startInstanceCache() throws Exception {
    }

    protected void startInvokers() throws Exception {
        for (String invokerBinding : this.proxyFactories.keySet()) {
            EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
            ci.start();
        }
    }

    protected void startInstancePool() throws Exception {
        this.instancePool.start();
    }

    protected void startInterceptors() throws Exception {
        for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
            in.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            super.stopService();
            this.stopInvokers();
            this.stopInstanceCache();
            this.stopInstancePool();
            this.stopPersistenceManager();
            this.stopInterceptors();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    protected void stopInterceptors() {
        for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
            in.stop();
        }
    }

    protected void stopPersistenceManager() {
    }

    protected void stopInstancePool() {
        this.instancePool.stop();
    }

    protected void stopInstanceCache() {
    }

    protected void stopInvokers() {
        for (String invokerBinding : this.proxyFactories.keySet()) {
            EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
            ci.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyService() throws Exception {
        ClassLoader oldCl = SecurityActions.getContextClassLoader();
        SecurityActions.setContextClassLoader(this.getClassLoader());
        this.pushENC();
        try {
            this.destroyInvokers();
            this.destroyInstanceCache();
            this.destroyInstancePool();
            this.destroyPersistenceManager();
            this.destroyInterceptors();
            this.destroyMarshalledInvocationMapping();
            this.homeInterface = null;
            this.remoteInterface = null;
            this.serviceEndpoint = null;
            this.beanMapping.clear();
            super.destroyService();
        }
        finally {
            this.popENC();
            SecurityActions.setContextClassLoader(oldCl);
        }
    }

    protected void destroyMarshalledInvocationMapping() {
        MarshalledInvocation.removeHashes(this.homeInterface);
        MarshalledInvocation.removeHashes(this.remoteInterface);
    }

    protected void destroyInterceptors() {
        for (Interceptor in = this.interceptor; in != null; in = in.getNext()) {
            in.destroy();
            in.setContainer(null);
        }
    }

    protected void destroyPersistenceManager() {
    }

    protected void destroyInstancePool() {
        this.instancePool.destroy();
        this.instancePool.setContainer(null);
        try {
            ObjectName containerName = super.getJmxName();
            Hashtable props = containerName.getKeyPropertyList();
            props.put("plugin", "pool");
            ObjectName poolName = new ObjectName(containerName.getDomain(), props);
            this.server.unregisterMBean(poolName);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void destroyInstanceCache() {
    }

    protected void destroyInvokers() {
        for (String invokerBinding : this.proxyFactories.keySet()) {
            EJBProxyFactory ci = (EJBProxyFactory)this.proxyFactories.get(invokerBinding);
            ci.destroy();
            ci.setContainer(null);
        }
    }

    public Object internalInvokeHome(Invocation mi) throws Exception {
        Method method = mi.getMethod();
        if (method != null && method.getName().equals("remove")) {
            Object arg = mi.getArguments()[0];
            if (arg instanceof Handle) {
                if (arg == null) {
                    throw new RemoteException("Null handle");
                }
                Handle handle = (Handle)arg;
                EJBObject ejbObject = handle.getEJBObject();
                ejbObject.remove();
                return null;
            }
            throw new RemoveException("EJBHome.remove(Object) not allowed for session beans");
        }
        return this.getInterceptor().invokeHome(mi);
    }

    public Object internalInvoke(Invocation mi) throws Exception {
        return this.getInterceptor().invoke(mi);
    }

    public Handle getHandle(Invocation mi) throws RemoteException {
        return null;
    }

    public Object getPrimaryKey(Invocation mi) throws RemoteException {
        return this.getPrimaryKey();
    }

    public Object getPrimaryKey() throws RemoteException {
        throw new RemoteException("Call to getPrimaryKey not allowed on session bean");
    }

    public EJBHome getEJBHome(Invocation mi) throws RemoteException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        return (EJBHome)ci.getEJBHome();
    }

    public boolean isIdentical(Invocation mi) throws RemoteException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        return ci.isIdentical(this, mi);
    }

    public EJBMetaData getEJBMetaDataHome(Invocation mi) throws RemoteException {
        return this.getEJBMetaDataHome();
    }

    public EJBMetaData getEJBMetaDataHome() throws RemoteException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        return ci.getEJBMetaData();
    }

    public HomeHandle getHomeHandleHome(Invocation mi) throws RemoteException {
        return this.getHomeHandleHome();
    }

    public HomeHandle getHomeHandleHome() throws RemoteException {
        EJBProxyFactory ci = this.getProxyFactory();
        if (ci == null) {
            String msg = "No ProxyFactory, check for ProxyFactoryFinderInterceptor";
            throw new IllegalStateException(msg);
        }
        EJBHome home = (EJBHome)ci.getEJBHome();
        return home.getHomeHandle();
    }

    public EJBLocalHome getEJBLocalHome(Invocation mi) {
        return this.localProxyFactory.getEJBLocalHome();
    }

    protected Map getHomeMapping() {
        return this.homeMapping;
    }

    protected Map getBeanMapping() {
        return this.beanMapping;
    }
}

