/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.jboss.ejb.Container;
import org.jboss.ejb.plugins.AbstractInterceptor;
import org.jboss.ejb.plugins.SecurityActions;
import org.jboss.invocation.Invocation;
import org.jboss.metadata.BeanMetaData;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.mx.util.MBeanServerLocator;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.Util;
import org.jboss.security.authorization.EJBResource;
import org.jboss.security.plugins.AuthorizationManagerServiceMBean;

public class SecurityAuthorizationInterceptor
extends AbstractInterceptor {
    protected boolean trace = this.log.isTraceEnabled();
    protected String ejbName = null;
    protected CodeSource ejbCS = null;
    protected AuthorizationManagerServiceMBean authorizationManagerService = (AuthorizationManagerServiceMBean)MBeanProxyExt.create(AuthorizationManagerServiceMBean.class, AuthorizationManagerServiceMBean.OBJECT_NAME, MBeanServerLocator.locateJBoss());
    protected String appSecurityDomain = null;
    protected String defaultAuthorizationSecurityDomain = "jboss-ejb-policy";

    public void setContainer(Container container) {
        super.setContainer(container);
        if (container != null) {
            BeanMetaData beanMetaData = container.getBeanMetaData();
            this.appSecurityDomain = container.getBeanMetaData().getApplicationMetaData().getSecurityDomain();
            this.ejbName = beanMetaData.getEjbName();
            this.ejbCS = container.getBeanClass().getProtectionDomain().getCodeSource();
        }
    }

    public Object invokeHome(Invocation mi) throws Exception {
        this.checkAuthorization(mi);
        Object returnValue = this.getNext().invokeHome(mi);
        return returnValue;
    }

    public Object invoke(Invocation mi) throws Exception {
        this.checkAuthorization(mi);
        Object returnValue = this.getNext().invoke(mi);
        return returnValue;
    }

    private void checkAuthorization(Invocation mi) throws Exception {
        Method ejbMethod = mi.getMethod();
        if (ejbMethod == null) {
            return;
        }
        Subject caller = SecurityActions.getContextSubject();
        AuthorizationManager authzManager = this.getAuthorizationManager();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ejb.name", this.ejbName);
        map.put("ejb.method", ejbMethod);
        map.put("ejb.principal", mi.getPrincipal());
        map.put("ejb.methodInterface", mi.getType().toInterfaceString());
        map.put("ejb.codeSource", this.ejbCS);
        map.put("caller.subject", caller);
        map.put("authorizationManager", authzManager);
        map.put("runAsIdentity", SecurityActions.peekRunAsIdentity());
        map.put("ejb.methodRoles", this.container.getMethodPermissions(ejbMethod, mi.getType()));
        EJBResource ejbResource = new EJBResource(map);
        boolean isAuthorized = false;
        try {
            int check = authzManager.authorize(ejbResource);
            isAuthorized = check == 1;
        }
        catch (Exception e) {
            isAuthorized = false;
            if (this.trace) {
                this.log.trace("Error in authorization:", e);
            }
            this.log.error("Error in authorization:" + e.getLocalizedMessage());
        }
        String msg = "Denied: caller=" + caller;
        if (!isAuthorized) {
            throw new SecurityException(msg);
        }
    }

    private AuthorizationManager getAuthorizationManager() throws Exception {
        String tempSecurityDomain = this.appSecurityDomain != null ? Util.unprefixSecurityDomain(this.appSecurityDomain) : this.defaultAuthorizationSecurityDomain;
        AuthorizationManager am = this.authorizationManagerService.getAuthorizationManager(tempSecurityDomain);
        if (this.trace) {
            this.log.trace(am.toString());
        }
        return am;
    }
}

