/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.RemoveException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityContainer;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCRelationshipRoleMetaData;
import org.jboss.logging.Logger;
import org.jboss.security.SecurityAssociation;

public abstract class CascadeDeleteStrategy {
    protected final JDBCCMRFieldBridge cmrField;
    protected final JDBCEntityBridge entity;
    protected final JDBCStoreManager relatedManager;
    protected final Logger log;

    public static CascadeDeleteStrategy getCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) throws DeploymentException {
        JDBCRelationshipRoleMetaData relatedRole = cmrField.getMetaData().getRelatedRole();
        CascadeDeleteStrategy result = relatedRole.isBatchCascadeDelete() ? new BatchCascadeDeleteStrategy(cmrField) : (relatedRole.isCascadeDelete() ? new DefaultCascadeDeleteStrategy(cmrField) : new NoneCascadeDeleteStrategy(cmrField));
        return result;
    }

    public CascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) throws DeploymentException {
        this.cmrField = cmrField;
        this.entity = (JDBCEntityBridge)cmrField.getEntity();
        this.relatedManager = cmrField.getRelatedManager();
        this.log = Logger.getLogger(this.getClass().getName() + "." + cmrField.getEntity().getEntityName());
    }

    public abstract void removedIds(EntityEnterpriseContext var1, Object[] var2, List var3);

    public abstract void cascadeDelete(EntityEnterpriseContext var1, List var2) throws RemoveException, RemoteException;

    protected void scheduleCascadeDelete(Object[] oldRelationsRef, List values) {
        HashMap<JDBCCMRFieldBridge, List> oldRelations = (HashMap<JDBCCMRFieldBridge, List>)oldRelationsRef[0];
        if (oldRelations == null) {
            oldRelationsRef[0] = oldRelations = new HashMap<JDBCCMRFieldBridge, List>();
        }
        oldRelations.put(this.cmrField, values);
        this.relatedManager.scheduleCascadeDelete(values);
    }

    protected void executeDeleteSQL(String sql, Object key) throws RemoveException {
        Connection con = null;
        PreparedStatement ps = null;
        int rowsAffected = 0;
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Executing SQL: " + sql);
            }
            con = this.entity.getDataSource().getConnection();
            ps = con.prepareStatement(sql);
            this.entity.setPrimaryKeyParameters(ps, 1, key);
            rowsAffected = ps.executeUpdate();
        }
        catch (Exception e) {
            try {
                this.log.error("Could not remove " + key, e);
                throw new RemoveException("Could not remove " + key);
            }
            catch (Throwable throwable) {
                JDBCUtil.safeClose(ps);
                JDBCUtil.safeClose(con);
                throw throwable;
            }
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(con);
        if (rowsAffected == 0) {
            this.log.error("Could not remove entity " + key);
            throw new RemoveException("Could not remove entity");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Remove: Rows affected = " + rowsAffected);
        }
    }

    public void invokeRemoveRelated(Object relatedId) throws RemoveException, RemoteException {
        EntityContainer container = this.relatedManager.getContainer();
        if (container.getLocalProxyFactory() != null) {
            EJBLocalObject ejbObject = container.getLocalProxyFactory().getEntityEJBLocalObject(relatedId);
            ejbObject.remove();
        } else {
            EJBObject ejbObject = (EJBObject)container.getProxyFactory().getEntityEJBObject(relatedId);
            ejbObject.remove();
        }
    }

    static interface SecurityActions {
        public static final SecurityActions NON_PRIVILEGED = new SecurityActions(){

            public Principal getPrincipal() {
                return SecurityAssociation.getPrincipal();
            }

            public Object getCredential() {
                return SecurityAssociation.getCredential();
            }
        };
        public static final SecurityActions PRIVILEGED = new SecurityActions(){
            private final PrivilegedAction getPrincipalAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getPrincipal();
                }
            };
            private final PrivilegedAction getCredentialAction = new PrivilegedAction(){

                public Object run() {
                    return SecurityAssociation.getCredential();
                }
            };

            public Principal getPrincipal() {
                return (Principal)AccessController.doPrivileged(this.getPrincipalAction);
            }

            public Object getCredential() {
                return AccessController.doPrivileged(this.getCredentialAction);
            }
        };

        public Principal getPrincipal();

        public Object getCredential();

        public static class UTIL {
            static SecurityActions getSecurityActions() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }
        }
    }

    public static final class BatchCascadeDeleteStrategy
    extends CascadeDeleteStrategy {
        private final String batchCascadeDeleteSql;

        public BatchCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) throws DeploymentException {
            super(cmrField);
            if (cmrField.hasForeignKey()) {
                throw new DeploymentException("Batch cascade-delete was setup for the role with a foreign key: relationship " + cmrField.getMetaData().getRelationMetaData().getRelationName() + ", role " + cmrField.getMetaData().getRelationshipRoleName() + ". Batch cascade-delete supported only for roles with no foreign keys.");
            }
            StringBuffer buf = new StringBuffer(100);
            buf.append("DELETE FROM ").append(cmrField.getRelatedJDBCEntity().getQualifiedTableName()).append(" WHERE ");
            SQLUtil.getWhereClause(cmrField.getRelatedCMRField().getForeignKeyFields(), buf);
            this.batchCascadeDeleteSql = buf.toString();
            this.log.debug(cmrField.getMetaData().getRelationMetaData().getRelationName() + " batch cascade delete SQL: " + this.batchCascadeDeleteSql);
        }

        public void removedIds(EntityEnterpriseContext ctx, Object[] oldRelationRefs, List ids) {
            this.cmrField.scheduleChildrenForBatchCascadeDelete(ctx);
            this.scheduleCascadeDelete(oldRelationRefs, new ArrayList(ids));
        }

        public void cascadeDelete(EntityEnterpriseContext ctx, List oldValues) throws RemoveException, RemoteException {
            boolean didDelete = false;
            boolean trace = this.log.isTraceEnabled();
            for (int i = 0; i < oldValues.size(); ++i) {
                Object oldValue = oldValues.get(i);
                if (this.relatedManager.unscheduledCascadeDelete(oldValue)) {
                    if (trace) {
                        this.log.trace("Removing " + oldValue);
                    }
                    this.invokeRemoveRelated(oldValue);
                    didDelete = true;
                    continue;
                }
                if (!trace) continue;
                this.log.trace(oldValue + " already removed");
            }
            if (didDelete) {
                this.executeDeleteSQL(this.batchCascadeDeleteSql, ctx.getId());
            }
        }
    }

    public static final class DefaultCascadeDeleteStrategy
    extends CascadeDeleteStrategy {
        public DefaultCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) throws DeploymentException {
            super(cmrField);
        }

        public void removedIds(EntityEnterpriseContext ctx, Object[] oldRelationRef, List ids) {
            this.cmrField.scheduleChildrenForCascadeDelete(ctx);
            this.scheduleCascadeDelete(oldRelationRef, new ArrayList(ids));
            this.cmrField.setInstanceValue(ctx, null);
        }

        public void cascadeDelete(EntityEnterpriseContext ctx, List oldValues) throws RemoveException, RemoteException {
            boolean trace = this.log.isTraceEnabled();
            for (int i = 0; i < oldValues.size(); ++i) {
                Object oldValue = oldValues.get(i);
                if (this.relatedManager.unscheduledCascadeDelete(oldValue)) {
                    if (trace) {
                        this.log.trace("Removing " + oldValue);
                    }
                    this.invokeRemoveRelated(oldValue);
                    continue;
                }
                if (!trace) continue;
                this.log.trace(oldValue + " already removed");
            }
        }
    }

    public static final class NoneCascadeDeleteStrategy
    extends CascadeDeleteStrategy {
        public NoneCascadeDeleteStrategy(JDBCCMRFieldBridge cmrField) throws DeploymentException {
            super(cmrField);
        }

        public void removedIds(EntityEnterpriseContext ctx, Object[] oldRelationRefs, List ids) {
            this.cmrField.setInstanceValue(ctx, null);
        }

        public void cascadeDelete(EntityEnterpriseContext ctx, List oldValues) throws RemoveException, RemoteException {
            boolean trace = this.log.isTraceEnabled();
            for (int i = 0; i < oldValues.size(); ++i) {
                Object oldValue = oldValues.get(i);
                if (this.relatedManager.unscheduledCascadeDelete(oldValue)) {
                    if (trace) {
                        this.log.trace("Removing " + oldValue);
                    }
                    this.invokeRemoveRelated(oldValue);
                    continue;
                }
                if (!trace) continue;
                this.log.trace(oldValue + " already removed");
            }
        }
    }
}

