/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javassist.bytecode.ClassFile;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.Entity;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import org.hibernate.cfg.EJB3DTDEntityResolver;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.jboss.ejb3.ClassFileFilter;
import org.jboss.ejb3.ClientDescriptorFileFilter;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3DescriptorHandler;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.Ejb3HandlerFactory;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.enc.EjbModuleEjbResolver;
import org.jboss.ejb3.enc.EjbModulePersistenceUnitResolver;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.ejb3.entity.PersistenceXmlLoader;
import org.jboss.ejb3.metamodel.EjbJarDD;
import org.jboss.ejb3.metamodel.EjbJarDDObjectFactory;
import org.jboss.ejb3.metamodel.JBossDDObjectFactory;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.xb.binding.JBossXBException;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ejb3Deployment {
    private static final Logger log = Logger.getLogger(Ejb3Deployment.class);
    public static final String ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT = "java:/ActualEntityManagerFactories";
    public static final String MANAGED_ENTITY_FACTORY_CONTEXT = "java:/managedEntityFactories";
    protected DeploymentUnit unit;
    protected LinkedHashMap<ObjectName, Container> ejbContainers = new LinkedHashMap();
    protected boolean hasEntities;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected List<PersistenceUnitDeployment> persistenceUnitDeployments = new ArrayList<PersistenceUnitDeployment>();
    protected String defaultSLSBDomain = "Stateless Bean";
    protected String defaultSFSBDomain = "Stateful Bean";
    protected String defaultMDBDomain = "Message Driven Bean";
    protected String defaultConsumerDomain = "Consumer Bean";
    protected String defaultServiceDomain = "Service Bean";
    protected InitialContext initialContext;
    protected KernelAbstraction kernelAbstraction;
    protected MBeanServer mbeanServer;
    protected DeploymentScope deploymentScope;
    protected EjbModuleEjbResolver ejbRefResolver;
    protected EjbModulePersistenceUnitResolver persistenceUnitResolver;
    PolicyConfiguration pc;

    public Ejb3Deployment(DeploymentUnit unit, DeploymentScope deploymentScope) {
        this.unit = unit;
        this.deploymentScope = deploymentScope;
        try {
            this.initialContext = EJB3Util.getInitialContext(unit.getJndiProperties());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.ejbRefResolver = new EjbModuleEjbResolver(deploymentScope, unit.getShortName(), this.ejbContainers, this);
        this.persistenceUnitResolver = new EjbModulePersistenceUnitResolver(this.persistenceUnitDeployments, deploymentScope, this.ejbContainers);
    }

    public DeploymentScope getEar() {
        return this.deploymentScope;
    }

    public KernelAbstraction getKernelAbstraction() {
        return this.kernelAbstraction;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.unit;
    }

    public String getDefaultSLSBDomain() {
        return this.defaultSLSBDomain;
    }

    public String getScopeKernelName() {
        String scopedKernelName = "";
        if (this.deploymentScope != null) {
            scopedKernelName = scopedKernelName + ",ear=" + this.deploymentScope.getShortName();
        }
        scopedKernelName = scopedKernelName + ",jar=" + this.unit.getShortName();
        return scopedKernelName;
    }

    public void setDefaultSLSBDomain(String defaultSLSBDomain) {
        this.defaultSLSBDomain = defaultSLSBDomain;
    }

    public String getDefaultSFSBDomain() {
        return this.defaultSFSBDomain;
    }

    public String getDefaultConsumerDomain() {
        return this.defaultConsumerDomain;
    }

    public void setDefaultSFSBDomain(String defaultSFSBDomain) {
        this.defaultSFSBDomain = defaultSFSBDomain;
    }

    public String getDefaultMDBDomain() {
        return this.defaultMDBDomain;
    }

    public void setDefaultMDBDomain(String defaultMDBDomain) {
        this.defaultMDBDomain = defaultMDBDomain;
    }

    public String getDefaultServiceDomain() {
        return this.defaultServiceDomain;
    }

    public void setDefaultServiceDomain(String defaultServiceDomain) {
        this.defaultServiceDomain = defaultServiceDomain;
    }

    protected String getJaccContextId() {
        return this.unit.getShortName();
    }

    public Container getContainer(ObjectName name) {
        return this.ejbContainers.get(name);
    }

    public Map getEjbContainers() {
        return this.ejbContainers;
    }

    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        return this.persistenceUnitResolver.getPersistenceUnitDeployment(unitName);
    }

    public PersistenceUnitDeployment getPersistenceUnitDeploymentInternal(String unitName) {
        return this.persistenceUnitResolver.getPersistenceUnitDeploymentInternal(unitName);
    }

    public List<PersistenceUnitDeployment> getPersistenceUnitDeployments() {
        return this.persistenceUnitDeployments;
    }

    public EJBContainer getEjbContainer(String ejbLink, Class businessIntf) {
        return this.ejbRefResolver.getEjbContainer(ejbLink, businessIntf);
    }

    public String getEjbJndiName(String ejbLink, Class businessIntf) {
        return this.ejbRefResolver.getEjbJndiName(ejbLink, businessIntf);
    }

    public EJBContainer getEjbContainer(Ejb3Deployment deployment, Class businessIntf) throws NameNotFoundException {
        return this.ejbRefResolver.getEjbContainer(deployment, businessIntf);
    }

    public EJBContainer getEjbContainer(Class businessIntf) throws NameNotFoundException {
        return this.ejbRefResolver.getEjbContainer(businessIntf);
    }

    public String getEjbJndiName(Class businessIntf) throws NameNotFoundException {
        return this.ejbRefResolver.getEjbJndiName(businessIntf);
    }

    protected void processEJBContainerMetadata(Container container) throws Exception {
        ObjectName on = container.getObjectName();
        this.ejbContainers.put(on, container);
        DependencyPolicy policy = this.createDependencyPolicy();
        container.processMetadata(policy);
    }

    protected void registerEJBContainer(Container container) throws Exception {
        ObjectName on = container.getObjectName();
        String name = on.getCanonicalName();
        this.kernelAbstraction.install(name, container.getDependencyPolicy(), container);
        log.debug("Bound ejb3 container " + name);
    }

    protected abstract PolicyConfiguration createPolicyConfiguration() throws Exception;

    protected abstract void putJaccInService(PolicyConfiguration var1, DeploymentUnit var2);

    public void create() throws Exception {
        long start = System.currentTimeMillis();
        this.pc = this.createPolicyConfiguration();
        this.deploy();
        this.initializePersistenceUnits();
        log.debug("EJB3 deployment time took: " + (System.currentTimeMillis() - start));
    }

    public void start() throws Exception {
        try {
            Container con;
            Container o;
            this.startPersistenceUnits();
            Iterator<Container> i$ = this.ejbContainers.values().iterator();
            while (i$.hasNext()) {
                con = o = i$.next();
                this.processEJBContainerMetadata(con);
            }
            i$ = this.ejbContainers.values().iterator();
            while (i$.hasNext()) {
                con = o = i$.next();
                this.registerEJBContainer(con);
            }
            this.putJaccInService(this.pc, this.unit);
        }
        catch (Exception ex) {
            try {
                this.stop();
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    protected void deploy() throws Exception {
        Ejb3HandlerFactory factory = Ejb3HandlerFactory.getInstance(this);
        if (this.unit.getUrl() != null) {
            this.deployUrl(factory);
        }
        if (this.unit.getClasses() != null) {
            for (Class explicit : this.unit.getClasses()) {
                if (explicit.isAnnotationPresent(Entity.class)) continue;
                String name = explicit.getName().replace('.', '/') + ".class";
                InputStream stream = explicit.getClassLoader().getResourceAsStream(name);
                this.deployElement(stream, factory, this.initialContext);
            }
        }
        this.deployBeansFromLib(this.initialContext);
    }

    protected void deployUrl(Ejb3HandlerFactory factory) throws Exception {
        List<VirtualFile> clientDescriptors = this.unit.getResources(new ClientDescriptorFileFilter());
        if (clientDescriptors.size() > 0) {
            return;
        }
        InitialContext ctx = this.initialContext;
        List<VirtualFile> classes = this.unit.getResources(new ClassFileFilter());
        for (VirtualFile classFile : classes) {
            InputStream stream = classFile.openStream();
            this.deployElement(stream, factory, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployElement(InputStream stream, Ejb3HandlerFactory factory, InitialContext ctx) throws Exception {
        DataInputStream dstream = new DataInputStream(new BufferedInputStream(stream));
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
        }
        finally {
            dstream.close();
            stream.close();
        }
        this.deployElement(factory, cf, ctx);
    }

    protected void deployBeansFromLib(InitialContext ctx) throws Exception {
        EjbJarDD dd = this.getMetaDataFomLib();
        if (dd != null) {
            Ejb3DescriptorHandler handler = new Ejb3DescriptorHandler(this, dd);
            handler.setCtxProperties(this.unit.getJndiProperties());
            HashMap<String, Container> localContainers = new HashMap<String, Container>();
            for (Container container : this.ejbContainers.values()) {
                localContainers.put(container.getEjbName(), container);
            }
            List containers = handler.getContainers(this, localContainers);
            for (Container con : containers) {
                ((EJBContainer)con).instantiated();
                this.ejbContainers.put(con.getObjectName(), con);
                Ejb3Registry.register(con);
            }
        }
    }

    protected EjbJarDD getMetaDataFomLib() throws JBossXBException, IOException {
        EjbJarDD dd = EjbJarDDObjectFactory.parse(this.getDeploymentUnit().getEjbJarXml());
        dd = JBossDDObjectFactory.parse(this.getDeploymentUnit().getJbossXml(), dd);
        return dd;
    }

    protected void deployElement(Ejb3HandlerFactory factory, ClassFile cf, InitialContext ctx) throws Exception {
        Ejb3Handler handler = factory.createHandler(cf);
        handler.setCtxProperties(this.unit.getJndiProperties());
        if (handler.isEjb() || handler.isJBossBeanType()) {
            List<Container> containers = handler.getContainers(cf, this);
            for (Container con : containers) {
                ((EJBContainer)con).instantiated();
                this.ejbContainers.put(con.getObjectName(), con);
                Ejb3Registry.register(con);
            }
        }
    }

    protected void initializePersistenceUnits() throws Exception {
        URL persistenceXmlUrl = null;
        persistenceXmlUrl = this.unit.getPersistenceXml();
        boolean bl = this.hasEntities = persistenceXmlUrl != null;
        if (!this.hasEntities) {
            return;
        }
        if (this.unit.getClasses() != null) {
            for (Class explicit : this.unit.getClasses()) {
                if (!explicit.isAnnotationPresent(Entity.class)) continue;
                this.explicitEntityClasses.add(explicit.getName());
            }
        }
        List<PersistenceMetadata> persistenceMetadata = PersistenceXmlLoader.deploy(persistenceXmlUrl, new HashMap(), (EntityResolver)new EJB3DTDEntityResolver(), PersistenceUnitTransactionType.JTA);
        for (PersistenceMetadata metadata : persistenceMetadata) {
            String earShortName = this.deploymentScope == null ? null : this.deploymentScope.getShortName();
            boolean isScoped = this.ejbContainers.size() > 0;
            PersistenceUnitDeployment deployment = new PersistenceUnitDeployment(this.initialContext, this, this.explicitEntityClasses, persistenceXmlUrl, metadata, earShortName, this.unit.getShortName(), isScoped);
            PersistenceUnitRegistry.register(deployment);
            this.persistenceUnitDeployments.add(deployment);
        }
    }

    public abstract DependencyPolicy createDependencyPolicy();

    protected void startPersistenceUnits() {
        if (this.persistenceUnitDeployments == null) {
            return;
        }
        for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments) {
            if (entityDeployment == null) continue;
            DependencyPolicy policy = this.createDependencyPolicy();
            entityDeployment.addDependencies(policy);
            this.kernelAbstraction.install(entityDeployment.getKernelName(), policy, entityDeployment);
        }
    }

    protected void stopPersistenceUnits() {
        if (this.persistenceUnitDeployments == null) {
            return;
        }
        for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments) {
            try {
                PersistenceUnitRegistry.unregister(entityDeployment);
                if (entityDeployment == null) continue;
                this.kernelAbstraction.uninstall(entityDeployment.getKernelName());
            }
            catch (Exception e) {
                log.debug("error trying to shut down persistence unit", e);
            }
        }
    }

    public void stop() throws Exception {
        for (ObjectName o : this.ejbContainers.keySet()) {
            try {
                ObjectName on = o;
                this.kernelAbstraction.uninstall(on.getCanonicalName());
            }
            catch (Exception e) {
                log.debug("error trying to shut down ejb container", e);
            }
        }
        this.stopPersistenceUnits();
    }

    public void destroy() throws Exception {
        this.undeploy();
        PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        PolicyConfiguration pc = pcFactory.getPolicyConfiguration(this.getJaccContextId(), true);
        pc.delete();
    }

    private void undeploy() {
        for (Container container : this.ejbContainers.values()) {
            Ejb3Registry.unregister(container);
        }
    }
}

