/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.resource;

import javax.management.ObjectName;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkManager;
import javax.transaction.xa.Xid;
import org.jboss.ejb3.embedded.resource.Ejb3DeploymentInfo;
import org.jboss.ejb3.embedded.resource.WorkWrapper;
import org.jboss.logging.Logger;
import org.jboss.tm.JBossXATerminator;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.ThreadPool;

public class JBossWorkManager
implements WorkManager {
    private static final Logger log = Logger.getLogger(Ejb3DeploymentInfo.class);
    private ThreadPool threadPool = new BasicThreadPool();
    private JBossXATerminator xaTerminator;
    private ObjectName xaTerminatorName;

    public ObjectName getXATerminatorName() {
        return this.xaTerminatorName;
    }

    public void setXATerminatorName(ObjectName xaTerminatorName) {
        this.xaTerminatorName = xaTerminatorName;
    }

    public WorkManager getInstance() {
        return this;
    }

    public void doWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException {
        if (ctx == null) {
            ctx = new ExecutionContext();
        }
        WorkWrapper wrapper = new WorkWrapper(this, work, 2, startTimeout, ctx, listener);
        this.importWork(wrapper);
        this.executeWork(wrapper);
        if (wrapper.getWorkException() != null) {
            throw wrapper.getWorkException();
        }
    }

    public void doWork(Work work) throws WorkException {
        this.doWork(work, Long.MAX_VALUE, null, null);
    }

    public long startWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException {
        if (ctx == null) {
            ctx = new ExecutionContext();
        }
        WorkWrapper wrapper = new WorkWrapper(this, work, 1, startTimeout, ctx, listener);
        this.importWork(wrapper);
        this.executeWork(wrapper);
        if (wrapper.getWorkException() != null) {
            throw wrapper.getWorkException();
        }
        return wrapper.getBlockedElapsed();
    }

    public long startWork(Work work) throws WorkException {
        return this.startWork(work, Long.MAX_VALUE, null, null);
    }

    public void scheduleWork(Work work, long startTimeout, ExecutionContext ctx, WorkListener listener) throws WorkException {
        if (ctx == null) {
            ctx = new ExecutionContext();
        }
        WorkWrapper wrapper = new WorkWrapper(this, work, 0, startTimeout, ctx, listener);
        this.importWork(wrapper);
        this.executeWork(wrapper);
        if (wrapper.getWorkException() != null) {
            throw wrapper.getWorkException();
        }
    }

    public void scheduleWork(Work work) throws WorkException {
        this.scheduleWork(work, Long.MAX_VALUE, null, null);
    }

    protected void importWork(WorkWrapper wrapper) throws WorkException {
        Xid xid;
        ExecutionContext ctx = wrapper.getExecutionContext();
        if (ctx != null && (xid = ctx.getXid()) != null) {
            long timeout = ctx.getTransactionTimeout();
            this.xaTerminator.registerWork(wrapper.getWork(), xid, timeout);
        }
    }

    protected void executeWork(WorkWrapper wrapper) throws WorkException {
        this.threadPool.runTaskWrapper(wrapper);
    }

    protected void startWork(WorkWrapper wrapper) throws WorkException {
        Xid xid;
        ExecutionContext ctx = wrapper.getExecutionContext();
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.xaTerminator.startWork(wrapper.getWork(), xid);
        }
    }

    protected void endWork(WorkWrapper wrapper) {
        Xid xid;
        ExecutionContext ctx = wrapper.getExecutionContext();
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.xaTerminator.endWork(wrapper.getWork(), xid);
        }
    }

    protected void cancelWork(WorkWrapper wrapper) {
        Xid xid;
        ExecutionContext ctx = wrapper.getExecutionContext();
        if (ctx != null && (xid = ctx.getXid()) != null) {
            this.xaTerminator.cancelWork(wrapper.getWork(), xid);
        }
    }
}

