/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.metamodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jboss.ejb3.metamodel.ActivationConfig;
import org.jboss.ejb3.metamodel.CacheConfig;
import org.jboss.ejb3.metamodel.ClusterConfig;
import org.jboss.ejb3.metamodel.Ejb3PortComponent;
import org.jboss.ejb3.metamodel.EnterpriseBean;
import org.jboss.ejb3.metamodel.MessageDrivenBean;
import org.jboss.ejb3.metamodel.MethodAttributes;
import org.jboss.ejb3.metamodel.PoolConfig;
import org.jboss.ejb3.metamodel.RemoteBinding;
import org.jboss.ejb3.metamodel.SessionEnterpriseBean;
import org.jboss.ejb3.metamodel.XmlAnnotation;
import org.jboss.logging.Logger;
import org.jboss.metamodel.descriptor.EjbLocalRef;
import org.jboss.metamodel.descriptor.EjbRef;
import org.jboss.metamodel.descriptor.InjectionTarget;
import org.jboss.metamodel.descriptor.JndiRef;
import org.jboss.metamodel.descriptor.MessageDestinationRef;
import org.jboss.metamodel.descriptor.ResourceEnvRef;
import org.jboss.metamodel.descriptor.ResourceRef;
import org.jboss.ws.integration.ServiceRefMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnterpriseBeans {
    private static final Logger log = Logger.getLogger(EnterpriseBeans.class);
    private HashMap<String, EnterpriseBean> enterpriseBeans = new HashMap();
    private EnterpriseBean currentEjb;

    public void setPoolConfig(PoolConfig config) {
        this.currentEjb.setPoolConfig(config);
    }

    public void setDefaultActivationConfig(ActivationConfig config) {
        ((MessageDrivenBean)this.currentEjb).setDefaultActivationConfig(config);
    }

    public void setCacheConfig(CacheConfig config) {
        ((SessionEnterpriseBean)this.currentEjb).setCacheConfig(config);
    }

    public void setClustered(String clustered) {
        ((SessionEnterpriseBean)this.currentEjb).setClustered(clustered);
    }

    public void setConcurrent(String concurrent) {
        ((SessionEnterpriseBean)this.currentEjb).setConcurrent(concurrent);
    }

    public void addJndiRef(JndiRef ref) {
        this.currentEjb.addJndiRef(ref);
    }

    public void addXmlAnnotation(XmlAnnotation xmlAnnotation) {
        this.currentEjb.addXmlAnnotation(xmlAnnotation);
    }

    public void addRemoteBinding(RemoteBinding binding) {
        this.currentEjb.addRemoteBinding(binding);
    }

    public void addIgnoreDependency(InjectionTarget ignore) {
        this.currentEjb.addIgnoreDependency(ignore);
    }

    public void addResourceRef(ResourceRef ref) {
        this.currentEjb.mergeResourceRef(ref);
    }

    public void addResourceEnvRef(ResourceEnvRef ref) {
        this.currentEjb.mergeResourceEnvRef(ref);
    }

    public void addMessageDestinationRef(MessageDestinationRef ref) {
        this.currentEjb.mergeMessageDestinationRef(ref);
    }

    public void addServiceRef(ServiceRefMetaData ref) {
        this.currentEjb.addServiceRef(ref);
    }

    public ServiceRefMetaData getServiceRef(String name) {
        return this.currentEjb.getServiceRef(name);
    }

    public void addPortComponent(Ejb3PortComponent portComp) {
        this.currentEjb.setPortComponent(portComp);
    }

    public void setMethodAttributes(MethodAttributes attributes) {
        this.currentEjb.setMethodAttributes(attributes);
    }

    public void setCurrentEjbName(String currentEjbName, Class ejbClass) {
        this.currentEjb = this.createEjbByEjbName(currentEjbName, ejbClass);
    }

    public void addDependency(String depends) {
        this.currentEjb.addDependency(depends);
    }

    public void updateEjbRef(EjbRef ref) {
        this.currentEjb.updateEjbRef(ref);
    }

    public void updateEjbLocalRef(EjbLocalRef ref) {
        this.currentEjb.updateEjbLocalRef(ref);
    }

    public void updateResourceRef(ResourceRef ref) {
        this.currentEjb.updateResourceRef(ref);
    }

    public void updateResourceEnvRef(ResourceEnvRef ref) {
        this.currentEjb.updateResourceEnvRef(ref);
    }

    public void updateMessageDestinationRef(MessageDestinationRef ref) {
        this.currentEjb.updateMessageDestinationRef(ref);
    }

    public void setResourceAdapterName(String name) {
        ((MessageDrivenBean)this.currentEjb).setResourceAdaptorName(name);
    }

    public void setDestinationJndiName(String name) {
        ((MessageDrivenBean)this.currentEjb).setDestinationJndiName(name);
    }

    public void setMdbUser(String name) {
        ((MessageDrivenBean)this.currentEjb).setMdbUser(name);
    }

    public void setMdbPassword(String name) {
        ((MessageDrivenBean)this.currentEjb).setMdbPassword(name);
    }

    public void setMdbSubscriptionId(String id) {
        ((MessageDrivenBean)this.currentEjb).setMdbSubscriptionId(id);
    }

    public void setAopDomainName(String aopDomainName) {
        this.currentEjb.setAopDomainName(aopDomainName);
    }

    public void setRunAsPrincipal(String principal) {
        this.currentEjb.setRunAsPrincipal(principal);
    }

    public void setClusterConfig(ClusterConfig config) {
        ((SessionEnterpriseBean)this.currentEjb).setClusterConfig(config);
    }

    public void setCallByValue(boolean callByValue) {
        this.currentEjb.setCallByValue(callByValue);
    }

    public void setJndiName(String jndiName) {
        this.currentEjb.setJndiName(jndiName);
    }

    public void setHomeJndiName(String homeJndiName) {
        this.currentEjb.setHomeJndiName(homeJndiName);
    }

    public void setSecurityDomain(String securityDomain) {
        this.currentEjb.setSecurityDomain(securityDomain);
    }

    public void setLocalJndiName(String jndiName) {
        this.currentEjb.setLocalJndiName(jndiName);
    }

    public void setLocalHomeJndiName(String homeJndiName) {
        this.currentEjb.setLocalHomeJndiName(homeJndiName);
    }

    public EnterpriseBean createEjbByEjbName(String ejbName, Class ejbClass) {
        EnterpriseBean ejb = this.enterpriseBeans.get(ejbName);
        if (ejb != null) {
            return ejb;
        }
        try {
            ejb = (EnterpriseBean)ejbClass.newInstance();
            ejb.setEjbName(ejbName);
            this.enterpriseBeans.put(ejbName, ejb);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ejb;
    }

    public EnterpriseBean findEjbByEjbName(String ejbName) {
        return this.enterpriseBeans.get(ejbName);
    }

    public List<EnterpriseBean> findEjbsByClass(String className) {
        ArrayList<EnterpriseBean> result = new ArrayList<EnterpriseBean>();
        for (EnterpriseBean ejb : this.enterpriseBeans.values()) {
            String ejbClassName = ejb.getEjbClass();
            if (ejbClassName == null || !ejbClassName.equals(className)) continue;
            result.add(ejb);
        }
        return result;
    }

    public EnterpriseBean findEjbByRemote(String remote) {
        for (EnterpriseBean ejb : this.enterpriseBeans.values()) {
            if (ejb.getRemote() == null || !ejb.getRemote().equals(remote)) continue;
            return ejb;
        }
        return null;
    }

    public EnterpriseBean findEjbByLocal(String local) {
        for (EnterpriseBean ejb : this.enterpriseBeans.values()) {
            if (ejb.getLocal() == null || !ejb.getLocal().equals(local)) continue;
            return ejb;
        }
        return null;
    }

    public Collection<EnterpriseBean> getEnterpriseBeans() {
        return this.enterpriseBeans.values();
    }

    public void addEnterpriseBean(EnterpriseBean ejb) {
        this.enterpriseBeans.put(ejb.getEjbName(), ejb);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("[");
        sb.append("enterpriseBeans=").append(this.enterpriseBeans);
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EnterpriseBeans)) {
            return false;
        }
        EnterpriseBeans ejbs = (EnterpriseBeans)o;
        return !(this.enterpriseBeans != null ? !this.enterpriseBeans.equals(ejbs.enterpriseBeans) : ejbs.enterpriseBeans != null);
    }

    public int hashCode() {
        int result = this.enterpriseBeans != null ? this.enterpriseBeans.hashCode() : 0;
        return result;
    }
}

