/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.embedded.junit;

import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.embedded.Bootstrap;
import org.jboss.embedded.DeploymentGroup;

public class EmbeddedTestSetup
extends TestSetup {
    public EmbeddedTestSetup(Test test) {
        super(test);
    }

    protected void setUp() {
        EmbeddedTestSetup.testSetup();
    }

    public static void testSetup() {
        if (Bootstrap.getInstance().isStarted()) {
            return;
        }
        try {
            Bootstrap.getInstance().bootstrap();
        }
        catch (Exception error) {
            throw new RuntimeException("Failed to bootstrap", error);
        }
    }

    public static void testTearDown() {
    }

    protected void tearDown() {
    }

    public static Test getWrapper(Class testClass) {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(testClass);
        return new EmbeddedTestSetup((Test)suite);
    }

    public static Test deployClasspath(Class testClass, final String classpaths) {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(testClass);
        return new EmbeddedTestSetup((Test)suite){
            DeploymentGroup group;

            protected void setUp() {
                super.setUp();
                try {
                    this.group = Bootstrap.getInstance().createDeploymentGroup();
                    this.group.addClasspath(classpaths);
                    this.group.process();
                }
                catch (DeploymentException e) {
                    throw new RuntimeException("Unable to deploy classpath: " + classpaths, e);
                }
            }

            protected void tearDown() {
                try {
                    this.group.undeploy();
                }
                catch (DeploymentException e) {
                    throw new RuntimeException("Unable to undeploy classpath: " + classpaths, e);
                }
                super.tearDown();
            }
        };
    }

    public static Test deployResource(Class testClass, final String ... resources) {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(testClass);
        return new EmbeddedTestSetup((Test)suite){
            DeploymentGroup group;

            protected void setUp() {
                super.setUp();
                try {
                    this.group = Bootstrap.getInstance().createDeploymentGroup();
                    for (String resource : resources) {
                        this.group.addResource(resource);
                    }
                    this.group.process();
                }
                catch (DeploymentException e) {
                    String message = "Unable to deploy resources:";
                    for (String resource : resources) {
                        message = message + " " + resource;
                    }
                    throw new RuntimeException(message, e);
                }
            }

            protected void tearDown() {
                try {
                    this.group.undeploy();
                }
                catch (DeploymentException e) {
                    throw new RuntimeException("Unable to undeploy resources: " + resources, e);
                }
                super.tearDown();
            }
        };
    }
}

