/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.remoting;

import EDU.oswego.cs.dl.util.concurrent.QueuedExecutor;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.delegate.SessionDelegate;
import org.jboss.jms.message.JBossMessage;
import org.jboss.jms.message.MessageProxy;
import org.jboss.jms.server.endpoint.DefaultCancel;
import org.jboss.jms.server.endpoint.DeliveryInfo;
import org.jboss.logging.Logger;
import org.jboss.messaging.util.Future;
import org.jboss.messaging.util.prioritylinkedlist.BasicPriorityLinkedList;
import org.jboss.messaging.util.prioritylinkedlist.PriorityLinkedList;

public class MessageCallbackHandler {
    private static final Logger log = Logger.getLogger(MessageCallbackHandler.class);
    private static boolean trace = log.isTraceEnabled();
    private static final int WAIT_TIMEOUT = 30000;
    private PriorityLinkedList buffer;
    private SessionDelegate sessionDelegate;
    private ConsumerDelegate consumerDelegate;
    private int consumerID;
    private boolean isConnectionConsumer;
    private volatile Thread receiverThread;
    private MessageListener listener;
    private int ackMode;
    private boolean closed;
    private Object mainLock;
    private int maxBufferSize;
    private int minBufferSize;
    private QueuedExecutor sessionExecutor;
    private boolean listenerRunning;
    private int maxDeliveries;
    private String queueName;
    private long lastDeliveryId = -1L;
    private volatile boolean serverSending = true;
    private boolean waitingForLastDelivery;

    private static boolean checkExpiredOrReachedMaxdeliveries(MessageProxy proxy, SessionDelegate del, int maxDeliveries) {
        boolean reachedMaxDeliveries;
        JBossMessage msg = proxy.getMessage();
        boolean expired = msg.isExpired();
        boolean bl = reachedMaxDeliveries = proxy.getDeliveryCount() == maxDeliveries;
        if (expired || reachedMaxDeliveries) {
            if (trace) {
                if (expired) {
                    log.trace(proxy.getMessage() + " has expired, cancelling to server");
                } else {
                    log.trace(proxy.getMessage() + " has reached maximum delivery number, cancelling to server");
                }
            }
            DefaultCancel cancel = new DefaultCancel(proxy.getDeliveryId(), proxy.getDeliveryCount(), expired, reachedMaxDeliveries);
            try {
                del.cancelDelivery(cancel);
            }
            catch (JMSException e) {
                log.error("Failed to cancel delivery", e);
            }
            return true;
        }
        return false;
    }

    public static void callOnMessage(SessionDelegate sess, MessageListener listener, int consumerID, String queueName, boolean isConnectionConsumer, MessageProxy m, int ackMode, int maxDeliveries, SessionDelegate connectionConsumerSession) throws JMSException {
        block7: {
            if (MessageCallbackHandler.checkExpiredOrReachedMaxdeliveries(m, sess, maxDeliveries)) {
                return;
            }
            DeliveryInfo deliveryInfo = new DeliveryInfo(m, consumerID, queueName, connectionConsumerSession);
            m.incDeliveryCount();
            if (!isConnectionConsumer) {
                sess.preDeliver(deliveryInfo);
            }
            try {
                if (trace) {
                    log.trace("calling listener's onMessage(" + m + ")");
                }
                listener.onMessage(m);
                if (trace) {
                    log.trace("listener's onMessage() finished");
                }
            }
            catch (RuntimeException e) {
                long id = m.getMessage().getMessageID();
                log.error("RuntimeException was thrown from onMessage, " + id + " will be redelivered", e);
                if (ackMode != 1 && ackMode != 3) break block7;
                sess.recover();
            }
        }
        if (!isConnectionConsumer) {
            sess.postDeliver();
        }
    }

    public MessageCallbackHandler(boolean isCC, int ackMode, SessionDelegate sess, ConsumerDelegate cons, int consumerID, String queueName, int bufferSize, QueuedExecutor sessionExecutor, int maxDeliveries) {
        if (bufferSize < 1) {
            throw new IllegalArgumentException(this + " bufferSize must be > 0");
        }
        this.maxBufferSize = bufferSize;
        this.minBufferSize = bufferSize / 2;
        this.buffer = new BasicPriorityLinkedList(10);
        this.isConnectionConsumer = isCC;
        this.ackMode = ackMode;
        this.sessionDelegate = sess;
        this.consumerDelegate = cons;
        this.consumerID = consumerID;
        this.queueName = queueName;
        this.mainLock = new Object();
        this.sessionExecutor = sessionExecutor;
        this.maxDeliveries = maxDeliveries;
    }

    public void handleMessage(final Object message) throws Exception {
        this.sessionExecutor.execute(new Runnable(){

            public void run() {
                try {
                    MessageCallbackHandler.this.handleMessageInternal(message);
                }
                catch (Exception e) {
                    log.error("Failed to handle message", e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessageListener(MessageListener listener) throws JMSException {
        Object object = this.mainLock;
        synchronized (object) {
            if (this.receiverThread != null) {
                throw new IllegalStateException("Consumer is currently in receive(..). Cannot set MessageListener");
            }
            this.listener = listener;
            if (listener != null && !this.buffer.isEmpty()) {
                this.listenerRunning = true;
                this.queueRunner(new ListenerRunner());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelBuffer() throws JMSException {
        Object object = this.mainLock;
        synchronized (object) {
            if (!this.buffer.isEmpty()) {
                ArrayList<DefaultCancel> cancels = new ArrayList<DefaultCancel>();
                ListIterator i = this.buffer.iterator();
                while (i.hasNext()) {
                    MessageProxy mp = (MessageProxy)i.next();
                    DefaultCancel cancel = new DefaultCancel(mp.getDeliveryId(), mp.getDeliveryCount(), false, false);
                    cancels.add(cancel);
                }
                this.sessionDelegate.cancelDeliveries(cancels);
                this.buffer.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long lastDeliveryId) throws JMSException {
        this.waitForLastDelivery(lastDeliveryId);
        this.waitForOnMessageToComplete();
        Object object = this.mainLock;
        synchronized (object) {
            log.debug(this + " closing");
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.receiverThread != null) {
                this.mainLock.notify();
            }
            this.listener = null;
        }
        if (trace) {
            log.trace(this + " closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MessageProxy receive(long timeout) throws JMSException {
        MessageProxy m = null;
        Object object = this.mainLock;
        synchronized (object) {
            if (trace) {
                log.trace(this + " receiving, timeout = " + timeout);
            }
            if (this.closed) {
                if (trace) {
                    log.trace(this + " closed, returning null");
                }
                return null;
            }
            if (this.listener != null) {
                throw new JMSException("The consumer has a MessageListener set, cannot call receive(..)");
            }
            this.receiverThread = Thread.currentThread();
            long startTimestamp = System.currentTimeMillis();
            try {
                while (true) {
                    if (timeout == 0L) {
                        if (trace) {
                            log.trace(this + ": receive, no timeout");
                        }
                        if ((m = this.getMessage(0L)) == null) {
                            MessageProxy messageProxy = null;
                            return messageProxy;
                        }
                    } else if (timeout == -1L) {
                        if (trace) {
                            log.trace(this + ": receive, noWait");
                        }
                        if ((m = this.getMessage(-1L)) == null) {
                            if (trace) {
                                log.trace(this + ": no message available");
                            }
                            MessageProxy messageProxy = null;
                            return messageProxy;
                        }
                    } else {
                        if (trace) {
                            log.trace(this + ": receive, timeout " + timeout + " ms, blocking poll on queue");
                        }
                        if ((m = this.getMessage(timeout)) == null) {
                            if (trace) {
                                log.trace(this + ": " + timeout + " ms timeout expired");
                            }
                            MessageProxy messageProxy = null;
                            return messageProxy;
                        }
                    }
                    if (trace) {
                        log.trace(this + " received " + m + " after being blocked on buffer");
                    }
                    boolean ignore = MessageCallbackHandler.checkExpiredOrReachedMaxdeliveries(m, this.sessionDelegate, this.maxDeliveries);
                    if (!this.isConnectionConsumer && !ignore) {
                        DeliveryInfo info = new DeliveryInfo(m, this.consumerID, this.queueName, null);
                        m.incDeliveryCount();
                        this.sessionDelegate.preDeliver(info);
                        this.sessionDelegate.postDeliver();
                    }
                    if (!ignore) {
                        if (trace) {
                            log.trace(this + ": message " + m + " is not expired, pushing it to the caller");
                        }
                        break;
                    }
                    if (trace) {
                        log.trace(this + ": message expired or exceeded max deliveries, discarding");
                    }
                    if (timeout == 0L) continue;
                    timeout -= System.currentTimeMillis() - startTimestamp;
                }
            }
            finally {
                this.receiverThread = null;
            }
        }
        this.checkStart();
        if (trace) {
            log.trace(this + " receive() returning " + m);
        }
        return m;
    }

    public MessageListener getMessageListener() {
        return this.listener;
    }

    public String toString() {
        return "MessageCallbackHandler[" + this.consumerID + "]";
    }

    public int getConsumerId() {
        return this.consumerID;
    }

    public void setConsumerId(int consumerId) {
        this.consumerID = consumerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToFrontOfBuffer(MessageProxy proxy) throws Exception {
        Object object = this.mainLock;
        synchronized (object) {
            this.buffer.addFirst(proxy, proxy.getJMSPriority());
            this.messageAdded();
        }
    }

    public void synchronizeWith(MessageCallbackHandler newHandler) {
        this.consumerID = newHandler.consumerID;
        this.buffer.clear();
        this.serverSending = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForLastDelivery(long id) {
        if (trace) {
            log.trace("Waiting for last delivery id " + id);
        }
        Object object = this.mainLock;
        synchronized (object) {
            this.waitingForLastDelivery = true;
            try {
                long start;
                for (long wait = 30000L; this.lastDeliveryId != id && wait > 0L; wait -= System.currentTimeMillis() - start) {
                    start = System.currentTimeMillis();
                    try {
                        this.mainLock.wait(wait);
                        continue;
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                }
                if (trace && this.lastDeliveryId == id) {
                    log.trace("Got last delivery");
                }
                if (this.lastDeliveryId != id) {
                    log.warn("Timed out waiting for last delivery");
                }
            }
            finally {
                this.waitingForLastDelivery = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessageInternal(Object message) throws Exception {
        MessageProxy proxy = (MessageProxy)message;
        if (trace) {
            log.trace(this + " receiving message " + proxy + " from the remoting layer");
        }
        Object object = this.mainLock;
        synchronized (object) {
            if (this.closed) {
                log.warn(this + " is closed, so ignoring message");
                return;
            }
            proxy.setSessionDelegate(this.sessionDelegate, this.isConnectionConsumer);
            this.buffer.addLast(proxy, proxy.getJMSPriority());
            this.lastDeliveryId = proxy.getDeliveryId();
            if (trace) {
                log.trace(this + " added message(s) to the buffer");
            }
            this.messageAdded();
            this.checkStop();
        }
    }

    private void checkStop() {
        int size = this.buffer.size();
        if (this.serverSending && size >= this.maxBufferSize) {
            this.sendChangeRateMessage(0.0f);
            if (trace) {
                log.trace("Sent changeRate 0 message");
            }
            this.serverSending = false;
        }
    }

    private void checkStart() {
        int size = this.buffer.size();
        if (!this.serverSending && size <= this.minBufferSize) {
            this.sendChangeRateMessage(1.0f);
            if (trace) {
                log.trace("Sent changeRate 1.0 message");
            }
            this.serverSending = true;
        }
    }

    private void sendChangeRateMessage(float newRate) {
        try {
            this.consumerDelegate.changeRate(newRate);
        }
        catch (JMSException e) {
            log.error("Failed to send changeRate message", e);
        }
    }

    private void waitForOnMessageToComplete() {
        if (Thread.currentThread().equals(this.sessionExecutor.getThread())) {
            return;
        }
        Future result = new Future();
        try {
            this.sessionExecutor.execute((Runnable)new Closer(result));
            if (trace) {
                log.trace(this + " blocking wait for Closer execution");
            }
            result.getResult();
            if (trace) {
                log.trace(this + " got Closer result");
            }
        }
        catch (InterruptedException e) {
            log.warn("Thread interrupted", e);
        }
    }

    private void queueRunner(ListenerRunner runner) {
        try {
            this.sessionExecutor.execute((Runnable)runner);
        }
        catch (InterruptedException e) {
            log.warn("Thread interrupted", e);
        }
    }

    private void messageAdded() {
        boolean notified = false;
        if (this.receiverThread != null) {
            if (trace) {
                log.trace(this + " notifying receiver/waiter thread");
            }
            this.mainLock.notifyAll();
            notified = true;
        } else if (this.listener != null && !this.listenerRunning) {
            this.listenerRunning = true;
            if (trace) {
                log.trace(this + " scheduled a new ListenerRunner");
            }
            this.queueRunner(new ListenerRunner());
        }
        if (this.waitingForLastDelivery && !notified) {
            this.mainLock.notifyAll();
        }
    }

    private long waitOnLock(Object lock, long waitTime) throws InterruptedException {
        long start = System.currentTimeMillis();
        lock.wait(waitTime);
        long waited = System.currentTimeMillis() - start;
        if (waited < waitTime) {
            return waitTime -= waited;
        }
        return 0L;
    }

    private MessageProxy getMessage(long timeout) {
        if (timeout != -1L) {
            try {
                if (timeout == 0L) {
                    while (!this.closed && this.buffer.isEmpty()) {
                        if (trace) {
                            log.trace(this + " waiting on main lock, no timeout");
                        }
                        this.mainLock.wait();
                        if (!trace) continue;
                        log.trace(this + " done waiting on main lock");
                    }
                } else {
                    long toWait = timeout;
                    while (!this.closed && this.buffer.isEmpty() && toWait > 0L) {
                        if (trace) {
                            log.trace(this + " waiting on main lock, timeout " + toWait + " ms");
                        }
                        toWait = this.waitOnLock(this.mainLock, toWait);
                        if (!trace) continue;
                        log.trace(this + " done waiting on lock, buffer is " + (this.buffer.isEmpty() ? "" : "NOT ") + "empty");
                    }
                }
            }
            catch (InterruptedException e) {
                if (trace) {
                    log.trace("InterruptedException, " + this + ".getMessage() returning null");
                }
                return null;
            }
        }
        MessageProxy m = null;
        if (!this.closed && !this.buffer.isEmpty()) {
            m = (MessageProxy)this.buffer.removeFirst();
        }
        return m;
    }

    private class ListenerRunner
    implements Runnable {
        private ListenerRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            MessageProxy mp = null;
            boolean again = false;
            Object object = MessageCallbackHandler.this.mainLock;
            synchronized (object) {
                if (MessageCallbackHandler.this.listener == null) {
                    MessageCallbackHandler.this.listenerRunning = false;
                    if (trace) {
                        log.trace("no listener, returning");
                    }
                    return;
                }
                if (MessageCallbackHandler.this.buffer.isEmpty()) {
                    MessageCallbackHandler.this.listenerRunning = false;
                    if (trace) {
                        log.trace("no messages in buffer, marking listener as not running");
                    }
                } else {
                    mp = (MessageProxy)MessageCallbackHandler.this.buffer.removeFirst();
                    if (mp == null) {
                        throw new java.lang.IllegalStateException("Cannot find message in buffer!");
                    }
                    boolean bl = again = !MessageCallbackHandler.this.buffer.isEmpty();
                    if (!again) {
                        MessageCallbackHandler.this.listenerRunning = false;
                        if (trace) {
                            log.trace("no more messages in buffer, marking listener as not running");
                        }
                    }
                }
            }
            if (mp != null) {
                try {
                    MessageCallbackHandler.callOnMessage(MessageCallbackHandler.this.sessionDelegate, MessageCallbackHandler.this.listener, MessageCallbackHandler.this.consumerID, MessageCallbackHandler.this.queueName, false, mp, MessageCallbackHandler.this.ackMode, MessageCallbackHandler.this.maxDeliveries, null);
                }
                catch (JMSException e) {
                    log.error("Failed to deliver message", e);
                }
            }
            MessageCallbackHandler.this.checkStart();
            if (again) {
                MessageCallbackHandler.this.queueRunner(this);
            }
        }
    }

    private class Closer
    implements Runnable {
        Future result;

        Closer(Future result) {
            this.result = result;
        }

        public void run() {
            if (trace) {
                log.trace("Closer starts running");
            }
            this.result.setResult(null);
            if (trace) {
                log.trace("Closer finished run");
            }
        }
    }
}

