/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.client.state;

import java.util.Collections;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.DelegateSupport;
import org.jboss.jms.client.remoting.CallbackManager;
import org.jboss.jms.client.remoting.MessageCallbackHandler;
import org.jboss.jms.client.state.HierarchicalState;
import org.jboss.jms.client.state.HierarchicalStateSupport;
import org.jboss.jms.client.state.SessionState;
import org.jboss.jms.delegate.ConsumerDelegate;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.jms.server.Version;

public class ConsumerState
extends HierarchicalStateSupport {
    private int consumerID;
    private JBossDestination destination;
    private String selector;
    private String subscriptionName;
    private boolean noLocal;
    private boolean isConnectionConsumer;
    private MessageCallbackHandler messageCallbackHandler;
    private int bufferSize;
    private int maxDeliveries;
    private boolean storingDeliveries;
    private SessionState parent;
    private ConsumerDelegate delegate;

    public ConsumerState(SessionState parent, ConsumerDelegate delegate, JBossDestination dest, String selector, boolean noLocal, String subscriptionName, int consumerID, boolean isCC, int bufferSize, int maxDeliveries) {
        super(parent, (DelegateSupport)((Object)delegate));
        this.children = Collections.EMPTY_SET;
        this.destination = dest;
        this.selector = selector;
        this.noLocal = noLocal;
        this.consumerID = consumerID;
        this.isConnectionConsumer = isCC;
        this.bufferSize = bufferSize;
        this.subscriptionName = subscriptionName;
        this.maxDeliveries = maxDeliveries;
        this.storingDeliveries = !dest.isTopic() || subscriptionName != null;
    }

    public DelegateSupport getDelegate() {
        return (DelegateSupport)((Object)this.delegate);
    }

    public void setDelegate(DelegateSupport delegate) {
        this.delegate = (ConsumerDelegate)((Object)delegate);
    }

    public HierarchicalState getParent() {
        return this.parent;
    }

    public void setParent(HierarchicalState parent) {
        this.parent = (SessionState)parent;
    }

    public Version getVersionToUse() {
        return this.parent.getVersionToUse();
    }

    public void synchronizeWith(HierarchicalState ns) throws Exception {
        ConsumerState newState = (ConsumerState)ns;
        int oldConsumerID = this.consumerID;
        this.consumerID = newState.consumerID;
        CallbackManager oldCallbackManager = ((ClientConnectionDelegate)this.getParent().getParent().getDelegate()).getRemotingConnection().getCallbackManager();
        CallbackManager newCallbackManager = ((ClientConnectionDelegate)ns.getParent().getParent().getDelegate()).getRemotingConnection().getCallbackManager();
        MessageCallbackHandler handler = oldCallbackManager.unregisterHandler(oldConsumerID);
        MessageCallbackHandler newHandler = newCallbackManager.unregisterHandler(this.consumerID);
        handler.synchronizeWith(newHandler);
        newCallbackManager.registerHandler(this.consumerID, handler);
    }

    public JBossDestination getDestination() {
        return this.destination;
    }

    public String getSelector() {
        return this.selector;
    }

    public boolean isNoLocal() {
        return this.noLocal;
    }

    public int getConsumerID() {
        return this.consumerID;
    }

    public boolean isConnectionConsumer() {
        return this.isConnectionConsumer;
    }

    public void setMessageCallbackHandler(MessageCallbackHandler handler) {
        this.messageCallbackHandler = handler;
    }

    public MessageCallbackHandler getMessageCallbackHandler() {
        return this.messageCallbackHandler;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    public void setSubscriptionName(String subscriptionName) {
        this.subscriptionName = subscriptionName;
    }

    public int getMaxDeliveries() {
        return this.maxDeliveries;
    }

    public boolean isStoringDeliveries() {
        return this.storingDeliveries;
    }
}

