/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import javax.jms.JMSException;
import org.jboss.jms.server.endpoint.ConnectionEndpoint;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.plugin.IDBlock;

public class MessageIdGenerator {
    private static final Logger log = Logger.getLogger(MessageIdGenerator.class);
    private boolean trace = log.isTraceEnabled();
    protected long high;
    protected long nextID;
    protected int blockSize;

    public MessageIdGenerator(int blockSize) throws JMSException {
        this.blockSize = blockSize;
    }

    protected void getNextBlock(ConnectionEndpoint connection) throws JMSException {
        IDBlock block = connection.getIdBlock(this.blockSize);
        this.nextID = block.getLow();
        this.high = block.getHigh();
        if (this.trace) {
            log.trace("Got block of IDs from server, low=" + this.nextID + " high=" + this.high);
        }
    }

    public synchronized long getId(ConnectionEndpoint connection) throws JMSException {
        if (this.nextID == this.high) {
            this.getNextBlock(connection);
        }
        long id = this.nextID;
        if (log.isTraceEnabled()) {
            log.trace("Getting next message id=" + id);
        }
        ++this.nextID;
        return id;
    }
}

