/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server;

import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.plugin.contract.Condition;

public class JMSCondition
implements Condition {
    private static final String QUEUE_PREFIX = "queue.";
    private static final String TOPIC_PREFIX = "topic.";
    private boolean queue;
    private String name;
    private int hash = -1;

    public JMSCondition(boolean queue, String name) {
        this.queue = queue;
        this.name = name;
    }

    public JMSCondition(String text) {
        if (text.startsWith(QUEUE_PREFIX)) {
            this.queue = true;
            this.name = text.substring(QUEUE_PREFIX.length());
        } else if (text.startsWith(TOPIC_PREFIX)) {
            this.queue = false;
            this.name = text.substring(TOPIC_PREFIX.length());
        } else {
            throw new IllegalArgumentException("Illegal text: " + text);
        }
    }

    public boolean matches(Condition routingCondition, MessageReference ref) {
        return this.equals(routingCondition);
    }

    public String toText() {
        return (this.queue ? QUEUE_PREFIX : TOPIC_PREFIX) + this.name;
    }

    public boolean isQueue() {
        return this.queue;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (!(other instanceof JMSCondition)) {
            return false;
        }
        JMSCondition jmsCond = (JMSCondition)other;
        return jmsCond.queue == this.queue && jmsCond.name.equals(this.name);
    }

    public int hashCode() {
        if (this.hash == -1) {
            this.hash = 17;
            this.hash = 37 * this.hash + (this.queue ? 0 : 1);
            this.hash = 37 * this.hash + this.name.hashCode();
        }
        return this.hash;
    }

    public String toString() {
        return this.toText();
    }
}

