/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.bridge;

import javax.jms.Destination;
import javax.naming.Context;
import javax.naming.InitialContext;
import org.jboss.jms.jndi.JMSProviderAdapter;
import org.jboss.jms.server.bridge.Bridge;
import org.jboss.jms.server.bridge.BridgeMBean;
import org.jboss.jms.server.bridge.JNDIConnectionFactoryFactory;
import org.jboss.messaging.core.plugin.contract.MessagingComponent;
import org.jboss.messaging.core.plugin.contract.ServerPlugin;
import org.jboss.system.ServiceMBeanSupport;

public class BridgeService
extends ServiceMBeanSupport
implements ServerPlugin,
BridgeMBean {
    private Bridge bridge = new Bridge();
    private String sourceDestinationLookup;
    private String targetDestinationLookup;
    private String sourceProviderAdaptorLookup;
    private String targetProviderAdaptorLookup;

    public synchronized String getSourceProviderAdaptorLookup() {
        return this.sourceProviderAdaptorLookup;
    }

    public synchronized void setSourceProviderAdaptorLookup(String lookup) {
        if (this.bridge.isStarted()) {
            this.log.warn("Cannot set SourceProviderAdaptorLookup when bridge is started");
            return;
        }
        this.sourceProviderAdaptorLookup = this.checkAndTrim(lookup);
    }

    public synchronized String getTargetProviderAdaptorLookup() {
        return this.targetProviderAdaptorLookup;
    }

    public synchronized void setTargetProviderAdaptorLookup(String lookup) {
        if (this.bridge.isStarted()) {
            this.log.warn("Cannot set TargetProviderAdaptorLookup when bridge is started");
            return;
        }
        this.targetProviderAdaptorLookup = this.checkAndTrim(lookup);
    }

    public String getSourceDestinationLookup() {
        return this.sourceDestinationLookup;
    }

    public String getTargetDestinationLookup() {
        return this.targetDestinationLookup;
    }

    public void setSourceDestinationLookup(String lookup) {
        if (this.bridge.isStarted()) {
            this.log.warn("Cannot set SourceDestinationLookup when bridge is started");
            return;
        }
        this.sourceDestinationLookup = this.checkAndTrim(lookup);
    }

    public void setTargetDestinationLookup(String lookup) {
        if (this.bridge.isStarted()) {
            this.log.warn("Cannot set TargetDestinationLookup when bridge is started");
            return;
        }
        this.targetDestinationLookup = this.checkAndTrim(lookup);
    }

    public String getSourceUsername() {
        return this.bridge.getSourceUsername();
    }

    public String getSourcePassword() {
        return this.bridge.getSourcePassword();
    }

    public void setSourceUsername(String name) {
        this.bridge.setSourceUsername(name);
    }

    public void setSourcePassword(String pwd) {
        this.bridge.setSourcePassword(pwd);
    }

    public String getTargetUsername() {
        return this.bridge.getDestUsername();
    }

    public String getTargetPassword() {
        return this.bridge.getDestPassword();
    }

    public void setTargetUsername(String name) {
        this.bridge.setDestUserName(name);
    }

    public void setTargetPassword(String pwd) {
        this.bridge.setDestPassword(pwd);
    }

    public int getQualityOfServiceMode() {
        return this.bridge.getQualityOfServiceMode();
    }

    public void setQualityOfServiceMode(int mode) {
        this.bridge.setQualityOfServiceMode(mode);
    }

    public String getSelector() {
        return this.bridge.getSelector();
    }

    public void setSelector(String selector) {
        this.bridge.setSelector(selector);
    }

    public int getMaxBatchSize() {
        return this.bridge.getMaxBatchSize();
    }

    public void setMaxBatchSize(int size) {
        this.bridge.setMaxBatchSize(size);
    }

    public long getMaxBatchTime() {
        return this.bridge.getMaxBatchTime();
    }

    public void setMaxBatchTime(long time) {
        this.bridge.setMaxBatchTime(time);
    }

    public String getSubName() {
        return this.bridge.getSubName();
    }

    public void setSubName(String subname) {
        this.bridge.setSubName(subname);
    }

    public String getClientID() {
        return this.bridge.getClientID();
    }

    public void setClientID(String clientID) {
        this.bridge.setClientID(clientID);
    }

    public long getFailureRetryInterval() {
        return this.bridge.getFailureRetryInterval();
    }

    public void setFailureRetryInterval(long interval) {
        this.bridge.setFailureRetryInterval(interval);
    }

    public int getMaxRetries() {
        return this.bridge.getMaxRetries();
    }

    public void setMaxRetries(int retries) {
        this.bridge.setMaxRetries(retries);
    }

    public boolean isFailed() {
        return this.bridge.isFailed();
    }

    public boolean isPaused() {
        return this.bridge.isPaused();
    }

    public boolean isStarted() {
        return this.bridge.isStarted();
    }

    public MessagingComponent getInstance() {
        return this.bridge;
    }

    public void pause() throws Exception {
        this.bridge.pause();
    }

    public void resume() throws Exception {
        this.bridge.resume();
    }

    protected void startService() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Starting bridge");
        }
        super.startService();
        if (this.sourceProviderAdaptorLookup == null) {
            throw new IllegalArgumentException("sourceProviderAdaptorLookup cannot be null");
        }
        if (this.targetProviderAdaptorLookup == null) {
            throw new IllegalArgumentException("targetProviderAdaptorLookup cannot be null");
        }
        if (this.sourceDestinationLookup == null) {
            throw new IllegalArgumentException("Source destination lookup cannot be null");
        }
        if (this.targetDestinationLookup == null) {
            throw new IllegalArgumentException("Target destination lookup cannot be null");
        }
        InitialContext ic = new InitialContext();
        JMSProviderAdapter sourceAdaptor = (JMSProviderAdapter)ic.lookup(this.sourceProviderAdaptorLookup);
        boolean sameSourceAndTarget = this.sourceProviderAdaptorLookup.equals(this.targetProviderAdaptorLookup);
        JMSProviderAdapter targetAdaptor = sameSourceAndTarget ? sourceAdaptor : (JMSProviderAdapter)ic.lookup(this.targetProviderAdaptorLookup);
        Context icSource = sourceAdaptor.getInitialContext();
        Context icTarget = targetAdaptor.getInitialContext();
        Destination sourceDest = (Destination)icSource.lookup(this.sourceDestinationLookup);
        Destination targetDest = (Destination)icTarget.lookup(this.targetDestinationLookup);
        String sourceCFRef = sourceAdaptor.getFactoryRef();
        String targetCFRef = targetAdaptor.getFactoryRef();
        JNDIConnectionFactoryFactory sourceCff = new JNDIConnectionFactoryFactory(sourceAdaptor.getProperties(), sourceCFRef);
        JNDIConnectionFactoryFactory destCff = new JNDIConnectionFactoryFactory(targetAdaptor.getProperties(), targetCFRef);
        this.bridge.setSourceDestination(sourceDest);
        this.bridge.setTargetDestination(targetDest);
        this.bridge.setSourceConnectionFactoryFactory(sourceCff);
        this.bridge.setDestConnectionFactoryFactory(destCff);
        this.bridge.start();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Started bridge");
        }
    }

    protected void stopService() throws Exception {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Stopping bridge");
        }
        this.bridge.stop();
        if (this.log.isTraceEnabled()) {
            this.log.trace("Stopped bridge");
        }
    }

    private String checkAndTrim(String s) {
        if (s != null && "".equals(s = s.trim())) {
            s = null;
        }
        return s;
    }
}

