/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.connectionfactory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.aop.AspectManager;
import org.jboss.jms.client.JBossConnectionFactory;
import org.jboss.jms.client.delegate.ClientClusteredConnectionFactoryDelegate;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.jms.client.plugin.LoadBalancingFactory;
import org.jboss.jms.client.plugin.LoadBalancingPolicy;
import org.jboss.jms.delegate.ConnectionFactoryDelegate;
import org.jboss.jms.server.ConnectionFactoryManager;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.Version;
import org.jboss.jms.server.connectionfactory.JNDIBindings;
import org.jboss.jms.server.endpoint.ServerConnectionFactoryEndpoint;
import org.jboss.jms.server.endpoint.advised.AdvisedSupport;
import org.jboss.jms.server.endpoint.advised.ConnectionFactoryAdvised;
import org.jboss.jms.util.JNDIUtil;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.logging.Logger;
import org.jboss.messaging.core.plugin.contract.FailoverMapper;
import org.jboss.messaging.core.plugin.contract.ReplicationListener;
import org.jboss.messaging.core.plugin.contract.Replicator;

public class ConnectionFactoryJNDIMapper
implements ConnectionFactoryManager,
ReplicationListener {
    private static final Logger log = Logger.getLogger(ConnectionFactoryJNDIMapper.class);
    private static final String CF_PREFIX = "CF_";
    private static boolean trace = log.isTraceEnabled();
    protected Context initialContext;
    protected ServerPeer serverPeer;
    protected Map endpoints;
    protected Map delegates;
    private Replicator replicator;
    protected Map failoverMap;

    public ConnectionFactoryJNDIMapper(ServerPeer serverPeer) throws Exception {
        this.serverPeer = serverPeer;
        this.endpoints = new HashMap();
        this.delegates = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerConnectionFactory(String uniqueName, String clientID, JNDIBindings jndiBindings, String locatorURI, boolean clientPing, int prefetchSize, int defaultTempQueueFullSize, int defaultTempQueuePageSize, int defaultTempQueueDownCacheSize, int dupsOKBatchSize, boolean clustered, LoadBalancingFactory loadBalancingFactory) throws Exception {
        ConnectionFactoryAdvised advised;
        log.debug(this + " registering connection factory '" + uniqueName + "', bindings: " + jndiBindings);
        if (this.delegates.containsKey(uniqueName)) {
            throw new IllegalArgumentException("There's already a connection factory registered with name " + uniqueName);
        }
        int id = this.serverPeer.getNextObjectID();
        Version version = this.serverPeer.getVersion();
        ServerConnectionFactoryEndpoint endpoint = new ServerConnectionFactoryEndpoint(id, this.serverPeer, clientID, jndiBindings, prefetchSize, defaultTempQueueFullSize, defaultTempQueuePageSize, defaultTempQueueDownCacheSize, dupsOKBatchSize);
        this.endpoints.put(uniqueName, endpoint);
        ConnectionFactoryDelegate delegate = null;
        if (clustered) {
            this.setupReplicator();
        }
        boolean creatingClustered = clustered && this.replicator != null;
        ClientConnectionFactoryDelegate localDelegate = new ClientConnectionFactoryDelegate(id, this.serverPeer.getServerPeerID(), locatorURI, version, clientPing);
        log.debug(this + " created local delegate " + localDelegate);
        if (creatingClustered) {
            this.replicator.put((Serializable)((Object)(CF_PREFIX + uniqueName)), localDelegate);
            Map localDelegates = this.replicator.get((Serializable)((Object)(CF_PREFIX + uniqueName)));
            delegate = this.createClusteredDelegate(localDelegates.values(), loadBalancingFactory);
            log.debug(this + " created clustered delegate " + delegate);
        } else {
            delegate = localDelegate;
        }
        log.trace(this + " adding delegates factory " + uniqueName + " pointing to " + delegate);
        this.delegates.put(uniqueName, delegate);
        this.rebindConnectionFactory(this.initialContext, jndiBindings, delegate);
        AspectManager aspectManager = AspectManager.instance();
        synchronized (aspectManager) {
            advised = new ConnectionFactoryAdvised(endpoint);
        }
        Dispatcher.instance.registerTarget(id, (AdvisedSupport)advised);
    }

    public synchronized void unregisterConnectionFactory(String uniqueName, boolean clustered) throws Exception {
        ConnectionFactoryDelegate delegate;
        log.trace("ConnectionFactory " + uniqueName + " being unregistered");
        ServerConnectionFactoryEndpoint endpoint = (ServerConnectionFactoryEndpoint)this.endpoints.remove(uniqueName);
        if (endpoint == null) {
            throw new IllegalArgumentException("Cannot find endpoint with name " + uniqueName);
        }
        JNDIBindings jndiBindings = endpoint.getJNDIBindings();
        if (jndiBindings != null) {
            List jndiNames = jndiBindings.getNames();
            Iterator i = jndiNames.iterator();
            while (i.hasNext()) {
                String jndiName = (String)i.next();
                this.initialContext.unbind(jndiName);
                log.debug(jndiName + " unregistered");
            }
        }
        if (trace) {
            log.trace("Removing delegate from delegates list with key=" + uniqueName + " at serverPeerID=" + this.serverPeer.getServerPeerID());
        }
        if ((delegate = (ConnectionFactoryDelegate)this.delegates.remove(uniqueName)) == null) {
            throw new IllegalArgumentException("Cannot find factory with name " + uniqueName);
        }
        if (clustered) {
            this.setupReplicator();
            if (this.replicator != null && !this.replicator.remove((Serializable)((Object)(CF_PREFIX + uniqueName)))) {
                throw new IllegalStateException("Cannot find replicant to remove: CF_" + uniqueName);
            }
        }
        Dispatcher.instance.unregisterTarget(endpoint.getID(), (Object)endpoint);
    }

    public void start() throws Exception {
        this.initialContext = new InitialContext();
        log.debug("started");
    }

    public void stop() throws Exception {
        this.initialContext.close();
        if (this.replicator != null) {
            this.replicator.unregisterListener(this);
        }
        log.debug("stopped");
    }

    public synchronized void onReplicationChange(Serializable key, Map updatedReplicantMap, boolean added, int originatorNodeID) {
        log.debug(this + " received " + key + " replication change from node " + originatorNodeID + ", new map " + updatedReplicantMap);
        try {
            if (!(key instanceof String)) {
                return;
            }
            String sKey = (String)((Object)key);
            if (sKey.equals("ADDRESS_INFO")) {
                this.failoverMap = this.recalculateFailoverMap(updatedReplicantMap.keySet());
                Iterator i = this.endpoints.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String uniqueName = (String)entry.getKey();
                    Object del = this.delegates.get(uniqueName);
                    if (del == null) {
                        throw new IllegalStateException("Cannot find connection factory with name " + uniqueName);
                    }
                    if (!(del instanceof ClientClusteredConnectionFactoryDelegate)) continue;
                    ((ClientClusteredConnectionFactoryDelegate)del).setFailoverMap(this.failoverMap);
                }
            } else if (sKey.startsWith(CF_PREFIX) && originatorNodeID != this.serverPeer.getServerPeerID()) {
                String uniqueName = sKey.substring(CF_PREFIX.length());
                log.debug(this + " received '" + uniqueName + "' connection factory update " + updatedReplicantMap);
                ClientClusteredConnectionFactoryDelegate del = (ClientClusteredConnectionFactoryDelegate)this.delegates.get(uniqueName);
                if (del == null) {
                    throw new IllegalStateException("Cannot find cf with name " + uniqueName);
                }
                List newDels = this.sortDelegatesOnServerID(updatedReplicantMap.values());
                ClientConnectionFactoryDelegate[] delArr = newDels.toArray(new ClientConnectionFactoryDelegate[newDels.size()]);
                del.setDelegates(delArr);
                ServerConnectionFactoryEndpoint endpoint = (ServerConnectionFactoryEndpoint)this.endpoints.get(uniqueName);
                if (endpoint == null) {
                    throw new IllegalStateException("Cannot find endpoint with name " + uniqueName);
                }
                this.rebindConnectionFactory(this.initialContext, endpoint.getJNDIBindings(), del);
                endpoint.updateClusteredClients(delArr, this.failoverMap);
            }
        }
        catch (Exception e) {
            log.error("Failed to rebind connection factory", e);
        }
    }

    public void injectReplicator(Replicator replicator) {
        this.replicator = replicator;
        replicator.registerListener(this);
    }

    public String toString() {
        return "Server[" + this.serverPeer.getServerPeerID() + "].ConnFactoryJNDIMapper";
    }

    private void setupReplicator() throws Exception {
        this.serverPeer.getPostOfficeInstance();
    }

    private Map recalculateFailoverMap(Set nodeIDs) throws Exception {
        FailoverMapper mapper = this.replicator.getFailoverMapper();
        return mapper.generateMapping(nodeIDs);
    }

    private ClientClusteredConnectionFactoryDelegate createClusteredDelegate(Collection localDelegates, LoadBalancingFactory loadBalancingFactory) throws Exception {
        log.trace(this + " creating a clustered ConnectionFactoryDelegate based on " + localDelegates);
        List sortedLocalDelegates = this.sortDelegatesOnServerID(localDelegates);
        ConnectionFactoryDelegate[] delegates = sortedLocalDelegates.toArray(new ClientConnectionFactoryDelegate[sortedLocalDelegates.size()]);
        if (this.failoverMap == null) {
            Map nodeAddressMap = this.replicator.get((Serializable)((Object)"ADDRESS_INFO"));
            if (nodeAddressMap == null) {
                throw new IllegalStateException("Cannot find address node mapping!");
            }
            this.failoverMap = this.recalculateFailoverMap(nodeAddressMap.keySet());
        }
        LoadBalancingPolicy lbp = loadBalancingFactory.createLoadBalancingPolicy(delegates);
        return new ClientClusteredConnectionFactoryDelegate((ClientConnectionFactoryDelegate[])delegates, this.failoverMap, lbp);
    }

    private void rebindConnectionFactory(Context ic, JNDIBindings jndiBindings, ConnectionFactoryDelegate delegate) throws NamingException {
        JBossConnectionFactory cf = new JBossConnectionFactory(delegate);
        if (jndiBindings != null) {
            List jndiNames = jndiBindings.getNames();
            Iterator i = jndiNames.iterator();
            while (i.hasNext()) {
                String jndiName = (String)i.next();
                log.debug(this + " rebinding " + cf + " as " + jndiName);
                JNDIUtil.rebind(ic, jndiName, cf);
            }
        }
    }

    private List sortDelegatesOnServerID(Collection delegates) {
        ArrayList localDels = new ArrayList(delegates);
        Collections.sort(localDels, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                ClientConnectionFactoryDelegate del1 = (ClientConnectionFactoryDelegate)obj1;
                ClientConnectionFactoryDelegate del2 = (ClientConnectionFactoryDelegate)obj2;
                return del1.getServerID() - del2.getServerID();
            }
        });
        return localDels;
    }
}

