/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.destination;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jboss.jms.server.JMSCondition;
import org.jboss.jms.server.destination.DestinationServiceSupport;
import org.jboss.jms.server.destination.ManagedTopic;
import org.jboss.jms.server.destination.TopicMBean;
import org.jboss.jms.server.messagecounter.MessageCounter;
import org.jboss.jms.util.ExceptionUtil;
import org.jboss.jms.util.MessageQueueNameHelper;
import org.jboss.jms.util.XMLUtil;
import org.jboss.messaging.core.local.PagingFilteredQueue;
import org.jboss.messaging.core.plugin.contract.ClusteredPostOffice;
import org.jboss.messaging.core.plugin.postoffice.Binding;

public class TopicService
extends DestinationServiceSupport
implements TopicMBean {
    public static final String SUBSCRIPTION_MESSAGECOUNTER_PREFIX = "Subscription.";

    public TopicService() {
        this.destination = new ManagedTopic();
    }

    public TopicService(boolean createdProgrammatically) {
        super(createdProgrammatically);
        this.destination = new ManagedTopic();
    }

    public synchronized void startService() throws Exception {
        super.startService();
        try {
            this.postOffice = this.serverPeer.getPostOfficeInstance();
            if (this.postOffice == null) {
                throw new IllegalArgumentException("Post Office instance not found. Check your destination configuration.");
            }
            this.destination.setServerPeer(this.serverPeer);
            JMSCondition topicCond = new JMSCondition(false, this.destination.getName());
            Collection bindings = this.postOffice.getBindingsForCondition(topicCond);
            Iterator iter = bindings.iterator();
            while (iter.hasNext()) {
                Binding binding = (Binding)iter.next();
                PagingFilteredQueue queue = (PagingFilteredQueue)binding.getQueue();
                queue.setPagingParams(this.destination.getFullSize(), this.destination.getPageSize(), this.destination.getDownCacheSize());
                queue.load();
                queue.activate();
                queue.setMaxSize(this.destination.getMaxSize());
                String counterName = SUBSCRIPTION_MESSAGECOUNTER_PREFIX + queue.getName();
                String subName = MessageQueueNameHelper.createHelper(queue.getName()).getSubName();
                int dayLimitToUse = this.destination.getMessageCounterHistoryDayLimit();
                if (dayLimitToUse == -1) {
                    dayLimitToUse = this.serverPeer.getDefaultMessageCounterHistoryDayLimit();
                }
                MessageCounter counter = new MessageCounter(counterName, subName, queue, true, true, dayLimitToUse);
                this.serverPeer.getMessageCounterManager().registerMessageCounter(counterName, counter);
            }
            this.dm.registerDestination(this.destination);
            this.log.debug(this + " security configuration: " + (this.destination.getSecurityConfig() == null ? "null" : "\n" + XMLUtil.elementToString(this.destination.getSecurityConfig())));
            this.started = true;
            this.log.info(this + " started, fullSize=" + this.destination.getFullSize() + ", pageSize=" + this.destination.getPageSize() + ", downCacheSize=" + this.destination.getDownCacheSize());
        }
        catch (Throwable t) {
            ExceptionUtil.handleJMXInvocation(t, this + " startService");
        }
    }

    public synchronized void stopService() throws Exception {
        try {
            this.dm.unregisterDestination(this.destination);
            JMSCondition topicCond = new JMSCondition(false, this.destination.getName());
            Collection bindings = this.postOffice.getBindingsForCondition(topicCond);
            Iterator iter = bindings.iterator();
            while (iter.hasNext()) {
                Binding binding = (Binding)iter.next();
                PagingFilteredQueue queue = (PagingFilteredQueue)binding.getQueue();
                if (!queue.isRecoverable()) {
                    queue.removeAllReferences();
                    if (!queue.isClustered()) {
                        this.postOffice.unbindQueue(queue.getName());
                    } else {
                        ((ClusteredPostOffice)this.postOffice).unbindClusteredQueue(queue.getName());
                    }
                }
                queue.deactivate();
                queue.unload();
                String counterName = SUBSCRIPTION_MESSAGECOUNTER_PREFIX + queue.getName();
                this.serverPeer.getMessageCounterManager().unregisterMessageCounter(counterName);
            }
            this.started = false;
            this.log.info(this + " stopped");
        }
        catch (Throwable t) {
            ExceptionUtil.handleJMXInvocation(t, this + " stopService");
        }
    }

    public int getAllMessageCount() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return -1;
            }
            return ((ManagedTopic)this.destination).getAllMessageCount();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getAllMessageCount");
        }
    }

    public int getDurableMessageCount() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return -1;
            }
            return ((ManagedTopic)this.destination).getDurableMessageCount();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getDurableMessageCount");
        }
    }

    public int getNonDurableMessageCount() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return -1;
            }
            return ((ManagedTopic)this.destination).getNonDurableMessageCount();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getNonDurableMessageCount");
        }
    }

    public int getAllSubscriptionsCount() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return 0;
            }
            return ((ManagedTopic)this.destination).getAllSubscriptionsCount();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getAllSubscriptionsCount");
        }
    }

    public int getDurableSubscriptionsCount() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return 0;
            }
            return ((ManagedTopic)this.destination).getDurableSubscriptionsCount();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getDurableSubscriptionsCount");
        }
    }

    public int getNonDurableSubscriptionsCount() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return 0;
            }
            return ((ManagedTopic)this.destination).getNonDurableSubscriptionsCount();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " getNonDurableSubscriptionsCount");
        }
    }

    public void removeAllMessages() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return;
            }
            ((ManagedTopic)this.destination).removeAllMessages();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " removeAllMessages");
        }
    }

    public List listAllSubscriptions() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return null;
            }
            return ((ManagedTopic)this.destination).listAllSubscriptions();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listAllSubscriptions");
        }
    }

    public List listDurableSubscriptions() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return null;
            }
            return ((ManagedTopic)this.destination).listDurableSubscriptions();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableSubscriptions");
        }
    }

    public List listNonDurableSubscriptions() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return null;
            }
            return ((ManagedTopic)this.destination).listNonDurableSubscriptions();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableSubscriptions");
        }
    }

    public String listAllSubscriptionsAsHTML() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return "";
            }
            return ((ManagedTopic)this.destination).listAllSubscriptionsAsHTML();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listAllSubscriptionsAsHTML");
        }
    }

    public String listDurableSubscriptionsAsHTML() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return "";
            }
            return ((ManagedTopic)this.destination).listDurableSubscriptionsAsHTML();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableSubscriptionsAsHTML");
        }
    }

    public String listNonDurableSubscriptionsAsHTML() throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return "";
            }
            return ((ManagedTopic)this.destination).listNonDurableSubscriptionsAsHTML();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableSubscriptionsAsHTML");
        }
    }

    public List listAllMessages(String subscriptionId) throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return null;
            }
            return ((ManagedTopic)this.destination).listAllMessages(subscriptionId, null);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listMessages");
        }
    }

    public List listAllMessages(String subscriptionId, String selector) throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return null;
            }
            return ((ManagedTopic)this.destination).listAllMessages(subscriptionId, selector);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listMessages");
        }
    }

    public List listDurableMessages(String subscriptionId) throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return null;
            }
            return ((ManagedTopic)this.destination).listDurableMessages(subscriptionId, null);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableMessages");
        }
    }

    public List listDurableMessages(String subscriptionId, String selector) throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return null;
            }
            return ((ManagedTopic)this.destination).listDurableMessages(subscriptionId, selector);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listDurableMessages");
        }
    }

    public List listNonDurableMessages(String subscriptionId) throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return null;
            }
            return ((ManagedTopic)this.destination).listNonDurableMessages(subscriptionId, null);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableMessages");
        }
    }

    public List listNonDurableMessages(String subscriptionId, String selector) throws Exception {
        try {
            if (!this.started) {
                this.log.warn("Topic is stopped.");
                return null;
            }
            return ((ManagedTopic)this.destination).listNonDurableMessages(subscriptionId, selector);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listNonDurableMessages");
        }
    }

    public List getMessageCounters() throws Exception {
        try {
            return ((ManagedTopic)this.destination).getMessageCounters();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMXInvocation(t, this + " listMessagesNonDurableSub");
        }
    }

    protected boolean isQueue() {
        return false;
    }
}

