/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.server.endpoint;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jms.JMSException;
import org.jboss.aop.AspectManager;
import org.jboss.jms.client.delegate.ClientConnectionDelegate;
import org.jboss.jms.client.delegate.ClientConnectionFactoryDelegate;
import org.jboss.jms.server.ServerPeer;
import org.jboss.jms.server.connectionfactory.JNDIBindings;
import org.jboss.jms.server.endpoint.ConnectionFactoryEndpoint;
import org.jboss.jms.server.endpoint.CreateConnectionResult;
import org.jboss.jms.server.endpoint.ServerConnectionEndpoint;
import org.jboss.jms.server.endpoint.advised.AdvisedSupport;
import org.jboss.jms.server.endpoint.advised.ConnectionAdvised;
import org.jboss.jms.util.ExceptionUtil;
import org.jboss.jms.wireformat.ConnectionFactoryUpdate;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.logging.Logger;
import org.jboss.remoting.callback.Callback;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;
import org.jboss.security.SecurityAssociation;

public class ServerConnectionFactoryEndpoint
implements ConnectionFactoryEndpoint {
    private static final Logger log = Logger.getLogger(ServerConnectionFactoryEndpoint.class);
    private ServerPeer serverPeer;
    private String clientID;
    private int id;
    private JNDIBindings jndiBindings;
    private int prefetchSize;
    protected int defaultTempQueueFullSize;
    protected int defaultTempQueuePageSize;
    protected int defaultTempQueueDownCacheSize;
    protected int dupsOKBatchSize;

    public ServerConnectionFactoryEndpoint(int id, ServerPeer serverPeer, String defaultClientID, JNDIBindings jndiBindings, int preFetchSize, int defaultTempQueueFullSize, int defaultTempQueuePageSize, int defaultTempQueueDownCacheSize, int dupsOKBatchSize) {
        this.serverPeer = serverPeer;
        this.clientID = defaultClientID;
        this.id = id;
        this.jndiBindings = jndiBindings;
        this.prefetchSize = preFetchSize;
        this.defaultTempQueueFullSize = defaultTempQueueFullSize;
        this.defaultTempQueuePageSize = defaultTempQueuePageSize;
        this.defaultTempQueueDownCacheSize = defaultTempQueueDownCacheSize;
        this.dupsOKBatchSize = dupsOKBatchSize;
    }

    public CreateConnectionResult createConnectionDelegate(String username, String password, int failedNodeID) throws JMSException {
        throw new IllegalStateException("createConnectionDelegate should never be called directly");
    }

    public CreateConnectionResult createConnectionDelegate(String username, String password, int failedNodeID, String remotingSessionID, String clientVMID, byte versionToUse, ServerInvokerCallbackHandler callbackHandler) throws JMSException {
        try {
            if (failedNodeID == -1) {
                ClientConnectionDelegate cd = this.createConnectionDelegateInternal(username, password, failedNodeID, remotingSessionID, clientVMID, versionToUse, callbackHandler);
                return new CreateConnectionResult(cd);
            }
            log.debug(this + " received client-side failover request. Creating failover " + "connection to replace connection to failed node " + failedNodeID);
            int failoverNodeID = this.serverPeer.waitForFailover(failedNodeID);
            if (failoverNodeID == -1 || failoverNodeID != this.serverPeer.getServerPeerID()) {
                log.debug(this + " realized that we are on the wrong node or no failover has occured");
                return new CreateConnectionResult(failoverNodeID);
            }
            log.debug(this + " received notification that server-side failover completed, " + "creating connection delegate ...");
            ClientConnectionDelegate cd = this.createConnectionDelegateInternal(username, password, failedNodeID, remotingSessionID, clientVMID, versionToUse, callbackHandler);
            return new CreateConnectionResult(cd);
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " createFailoverConnectionDelegate");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnectionDelegate createConnectionDelegateInternal(String username, String password, int failedNodeID, String remotingSessionID, String clientVMID, byte versionToUse, ServerInvokerCallbackHandler callbackHandler) throws Exception {
        ConnectionAdvised connAdvised;
        String preconfClientID;
        log.debug("creating a new connection for user " + username);
        this.serverPeer.getSecurityManager().authenticate(username, password);
        SecurityAssociation.popSubjectContext();
        String clientIDUsed = this.clientID;
        if (username != null && (preconfClientID = this.serverPeer.getJmsUserManagerInstance().getPreConfiguredClientID(username)) != null) {
            clientIDUsed = preconfClientID;
        }
        if (clientIDUsed != null) {
            this.serverPeer.checkClientID(clientIDUsed);
        }
        ServerConnectionEndpoint endpoint = new ServerConnectionEndpoint(this.serverPeer, clientIDUsed, username, password, this.prefetchSize, this.defaultTempQueueFullSize, this.defaultTempQueuePageSize, this.defaultTempQueueDownCacheSize, failedNodeID, this, remotingSessionID, clientVMID, versionToUse, callbackHandler, this.dupsOKBatchSize);
        int connectionID = endpoint.getConnectionID();
        AspectManager aspectManager = AspectManager.instance();
        synchronized (aspectManager) {
            connAdvised = new ConnectionAdvised(endpoint);
        }
        Dispatcher.instance.registerTarget(connectionID, (AdvisedSupport)connAdvised);
        log.debug("created and registered " + endpoint);
        aspectManager = AspectManager.instance();
        synchronized (aspectManager) {
            return new ClientConnectionDelegate(connectionID, this.serverPeer.getServerPeerID());
        }
    }

    public byte[] getClientAOPStack() throws JMSException {
        try {
            return this.serverPeer.getClientAOPStack();
        }
        catch (Throwable t) {
            throw ExceptionUtil.handleJMSInvocation(t, this + " getClientAOPStack");
        }
    }

    public int getID() {
        return this.id;
    }

    public JNDIBindings getJNDIBindings() {
        return this.jndiBindings;
    }

    public ServerPeer getServerPeer() {
        return this.serverPeer;
    }

    public void updateClusteredClients(ClientConnectionFactoryDelegate[] delegates, Map failoverMap) throws Exception {
        List activeConnections = this.serverPeer.getConnectionManager().getActiveConnections();
        ConnectionFactoryUpdate message = new ConnectionFactoryUpdate(delegates, failoverMap);
        Callback callback = new Callback(message);
        Iterator i = activeConnections.iterator();
        while (i.hasNext()) {
            ServerConnectionEndpoint connEndpoint = (ServerConnectionEndpoint)i.next();
            if (connEndpoint.getConnectionFactoryEndpoint() != this) continue;
            log.debug(this + " sending cluster view update to " + connEndpoint);
            try {
                connEndpoint.getCallbackHandler().handleCallbackOneway(callback);
            }
            catch (Exception e) {
                log.error("Callback failed on connection " + connEndpoint, e);
            }
        }
    }

    public String toString() {
        return "ConnectionFactoryEndpoint[" + this.id + "]";
    }
}

