/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.util;

import javax.jms.JMSException;
import org.jboss.jms.util.MessagingJMSException;
import org.jboss.logging.Logger;
import org.jboss.util.id.GUID;

public class ExceptionUtil {
    private static final Logger log = Logger.getLogger(ExceptionUtil.class);

    public static JMSException handleJMSInvocation(Throwable t, String msg) {
        String id = new GUID().toString();
        log.error(msg + " [" + id + "]", t);
        if (t instanceof JMSException) {
            return (JMSException)t;
        }
        MessagingJMSException e = new MessagingJMSException("A failure has occurred during processing of the request. Please consult the server logs for more details. " + msg + " [" + id + "]");
        return e;
    }

    public static Exception handleJMXInvocation(Throwable t, String msg) {
        log.error(msg, t);
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof Exception) {
            return (Exception)t;
        }
        throw new RuntimeException(msg);
    }
}

