/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.server.endpoint.CreateConnectionResult;
import org.jboss.jms.server.endpoint.advised.ConnectionFactoryAdvised;
import org.jboss.jms.wireformat.ConnectionFactoryCreateConnectionDelegateResponse;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;
import org.jboss.remoting.callback.ServerInvokerCallbackHandler;

public class ConnectionFactoryCreateConnectionDelegateRequest
extends RequestSupport {
    private String username;
    private String password;
    private int failedNodeId;
    private String remotingSessionId;
    private String clientVMId;
    private transient ServerInvokerCallbackHandler callbackHandler;

    public ConnectionFactoryCreateConnectionDelegateRequest() {
    }

    public ConnectionFactoryCreateConnectionDelegateRequest(int objectId, byte version, String remotingSessionId, String clientVMId, String username, String password, int failedNodeId) {
        super(objectId, 100, version);
        this.remotingSessionId = remotingSessionId;
        this.clientVMId = clientVMId;
        this.username = username;
        this.password = password;
        this.failedNodeId = failedNodeId;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        this.remotingSessionId = is.readUTF();
        this.clientVMId = is.readUTF();
        this.username = this.readNullableString(is);
        this.password = this.readNullableString(is);
        this.failedNodeId = is.readInt();
    }

    public ResponseSupport serverInvoke() throws Exception {
        ConnectionFactoryAdvised advised = (ConnectionFactoryAdvised)Dispatcher.instance.getTarget(this.objectId);
        if (advised == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        CreateConnectionResult del = advised.createConnectionDelegate(this.username, this.password, this.failedNodeId, this.remotingSessionId, this.clientVMId, this.version, this.callbackHandler);
        return new ConnectionFactoryCreateConnectionDelegateResponse(del);
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeUTF(this.remotingSessionId);
        os.writeUTF(this.clientVMId);
        this.writeNullableString(this.username, os);
        this.writeNullableString(this.password, os);
        os.writeInt(this.failedNodeId);
        os.flush();
    }

    public String getRemotingSessionID() {
        return this.remotingSessionId;
    }

    public String getClientVMID() {
        return this.clientVMId;
    }

    public ServerInvokerCallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    public void setCallbackHandler(ServerInvokerCallbackHandler handler) {
        this.callbackHandler = handler;
    }
}

