/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.wireformat;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.jboss.jms.server.endpoint.Ack;
import org.jboss.jms.server.endpoint.DefaultAck;
import org.jboss.jms.server.endpoint.SessionEndpoint;
import org.jboss.jms.wireformat.Dispatcher;
import org.jboss.jms.wireformat.RequestSupport;
import org.jboss.jms.wireformat.ResponseSupport;

public class SessionAcknowledgeDeliveryRequest
extends RequestSupport {
    private Ack ack;

    public SessionAcknowledgeDeliveryRequest() {
    }

    public SessionAcknowledgeDeliveryRequest(int objectId, byte version, Ack ack) {
        super(objectId, 306, version);
        this.ack = ack;
    }

    public void read(DataInputStream is) throws Exception {
        super.read(is);
        long deliveryId = is.readLong();
        this.ack = new DefaultAck(deliveryId);
    }

    public ResponseSupport serverInvoke() throws Exception {
        SessionEndpoint endpoint = (SessionEndpoint)Dispatcher.instance.getTarget(this.objectId);
        if (endpoint == null) {
            throw new IllegalStateException("Cannot find object in dispatcher with id " + this.objectId);
        }
        endpoint.acknowledgeDelivery(this.ack);
        return null;
    }

    public void write(DataOutputStream os) throws Exception {
        super.write(os);
        os.writeLong(this.ack.getDeliveryID());
        os.flush();
    }
}

