/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.dependency;

import java.util.Set;
import org.jboss.beans.info.spi.BeanInfo;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.joinpoint.spi.TargettedJoinpoint;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.dependency.KernelControllerContextAction;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.ConfigureKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.CreateKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.DescribeKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.InstallKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.InstantiateKernelControllerContextAware;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.kernel.spi.dependency.StartKernelControllerContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureAction
extends KernelControllerContextAction {
    @Override
    protected void installActionInternal(KernelControllerContext context) throws Throwable {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        Object object = context.getTarget();
        BeanInfo info = context.getBeanInfo();
        BeanMetaData metaData = context.getBeanMetaData();
        Set<TargettedJoinpoint> joinPoints = configurator.getPropertySetterJoinPoints(info, metaData);
        this.setAttributes(context, object, joinPoints, false);
        if (this.isExactlyKernelControllerContextAware(object)) {
            ((KernelControllerContextAware)object).setKernelControllerContext(context);
        }
    }

    @Override
    protected Class<? extends KernelControllerContextAware> getActionAwareInterface() {
        return ConfigureKernelControllerContextAware.class;
    }

    @Override
    protected void uninstallActionInternal(KernelControllerContext context) {
        KernelController controller = (KernelController)context.getController();
        Kernel kernel = controller.getKernel();
        KernelConfigurator configurator = kernel.getConfigurator();
        Object object = context.getTarget();
        try {
            if (object != null && this.isExactlyKernelControllerContextAware(object)) {
                ((KernelControllerContextAware)object).unsetKernelControllerContext(context);
            }
        }
        catch (Throwable ignored) {
            this.log.debug("Ignored error unsetting context ", ignored);
        }
        BeanInfo info = context.getBeanInfo();
        BeanMetaData metaData = context.getBeanMetaData();
        try {
            Set<TargettedJoinpoint> joinPoints = configurator.getPropertyNullerJoinPoints(info, metaData);
            this.setAttributes(context, object, joinPoints, true);
        }
        catch (Throwable t) {
            this.log.warn("Error unconfiguring bean " + context, t);
        }
    }

    protected void setAttributes(KernelControllerContext context, Object target, Set joinPoints, boolean ignoreErrors) throws Throwable {
        if (!joinPoints.isEmpty()) {
            boolean trace = this.log.isTraceEnabled();
            for (TargettedJoinpoint joinPoint : joinPoints) {
                joinPoint.setTarget(target);
                try {
                    ConfigureAction.dispatchJoinPoint(context, joinPoint);
                }
                catch (Throwable t) {
                    if (ignoreErrors) {
                        if (!trace) continue;
                        this.log.trace("Ignored for " + joinPoint, t);
                        continue;
                    }
                    throw t;
                }
            }
        }
    }

    private boolean isExactlyKernelControllerContextAware(Object o) {
        Class<?> clazz = o.getClass();
        return KernelControllerContextAware.class.isAssignableFrom(clazz) && !ConfigureKernelControllerContextAware.class.isAssignableFrom(clazz) && !CreateKernelControllerContextAware.class.isAssignableFrom(clazz) && !DescribeKernelControllerContextAware.class.isAssignableFrom(clazz) && !InstallKernelControllerContextAware.class.isAssignableFrom(clazz) && !InstantiateKernelControllerContextAware.class.isAssignableFrom(clazz) && !StartKernelControllerContextAware.class.isAssignableFrom(clazz);
    }
}

