/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.core;

import org.jboss.logging.Logger;
import org.jboss.messaging.core.Delivery;
import org.jboss.messaging.core.DeliveryObserver;
import org.jboss.messaging.core.message.MessageReference;
import org.jboss.messaging.core.tx.Transaction;

public class SimpleDelivery
implements Delivery {
    private static final Logger log = Logger.getLogger(SimpleDelivery.class);
    protected volatile boolean done;
    protected boolean selectorAccepted;
    protected DeliveryObserver observer;
    protected MessageReference reference;
    private boolean trace = log.isTraceEnabled();

    public SimpleDelivery() {
        this(null, null, false);
    }

    public SimpleDelivery(boolean d) {
        this(null, null, d);
    }

    public SimpleDelivery(DeliveryObserver observer, MessageReference reference) {
        this(observer, reference, false);
    }

    public SimpleDelivery(MessageReference reference, boolean done) {
        this(null, reference, done);
    }

    public SimpleDelivery(DeliveryObserver observer, MessageReference reference, boolean done) {
        this.done = done;
        this.reference = reference;
        this.observer = observer;
        this.selectorAccepted = true;
    }

    public SimpleDelivery(DeliveryObserver observer, MessageReference reference, boolean done, boolean selectorAccepted) {
        this.done = done;
        this.reference = reference;
        this.observer = observer;
        this.selectorAccepted = selectorAccepted;
    }

    public MessageReference getReference() {
        return this.reference;
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isSelectorAccepted() {
        return this.selectorAccepted;
    }

    public void setObserver(DeliveryObserver observer) {
        this.observer = observer;
    }

    public DeliveryObserver getObserver() {
        return this.observer;
    }

    public void acknowledge(Transaction tx) throws Throwable {
        if (this.trace) {
            log.trace(this + " acknowledging delivery " + (tx == null ? "non-transactionally" : "in " + tx));
        }
        this.observer.acknowledge(this, tx);
        this.done = true;
    }

    public void cancel() throws Throwable {
        if (this.trace) {
            log.trace(this + " cancelling delivery");
        }
        this.observer.cancel(this);
        this.done = true;
    }

    public String toString() {
        return "Delivery" + (this.reference == null ? "" : "[" + this.reference + "]") + "(" + (this.done ? "done" : "active") + ")";
    }
}

